package com.transsion.ad.middle.intercept.interstitial

import android.app.Activity
import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.mediation.ad.TBaseAd
import com.hisavana.mediation.ad.TInterstitialAd
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.AdContextManager
import com.transsion.ad.middle.intercept.BaseInterceptHiSavanaAdManager
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 14:42
 * @description: 插屏广告
 */
@Deprecated("使用 BiddingBuyOutInterstitialManager")
internal class HiSavanaInterstitialAdManager(private val mSceneId: String) :
    BaseInterceptHiSavanaAdManager(mSceneId) {

    companion object {

        /**
         * 因为所有的HiSavana 广告位ID都是服务端下发的,所以客户端会有多个对象
         */
        private val mAdMap by lazy {
            HashMap<String, HiSavanaInterstitialAdManager>()
        }

        /**
         * 通过广告位ID获取广告加载对象
         */
        fun getManager(sceneId: String?): HiSavanaInterstitialAdManager? {
            if (TextUtils.isEmpty(sceneId)) {
                return null
            }
            val hiSavanaPlacementId = SceneCommonConfig.getHiSavanaPlacementId(sceneId) ?: return null
            var manager = mAdMap[hiSavanaPlacementId]
            if (null == manager) {
                manager = HiSavanaInterstitialAdManager(sceneId ?: "")
                mAdMap[hiSavanaPlacementId] = manager
            }
            return manager
        }
    }


    // =============================================================================================


    /***广告加载对象*/
    private var tInterstitialAd: TInterstitialAd? = null

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun getAdInstance(): TBaseAd<*>? {
        // 如果对象不存在，那就创建新的
        if (null == tInterstitialAd) {
            val hiSavanaPlacementId = SceneCommonConfig.getHiSavanaPlacementId(mSceneId)
            tInterstitialAd = TInterstitialAd(Utils.getApp(), hiSavanaPlacementId)
            tInterstitialAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdListener(this).build()
            )
        }
        return tInterstitialAd
    }

    override fun show(topActivity: Activity, ctxMap: Map<String, Any>?) {
        if (AdContextManager.isDangerGenre(ctxMap)) {
            tInterstitialAd?.setContainVulgarContent(true)
        }
        tInterstitialAd?.show(topActivity)
    }

    override fun reset() {
        tInterstitialAd = null
    }

}