package com.transsion.ad.middle.intercept.interstitial

import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.view.TextureView
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.AppCompatTextView
import androidx.appcompat.widget.LinearLayoutCompat
import androidx.constraintlayout.widget.ConstraintLayout
import com.transsion.ad.AdLogger
import com.transsion.ad.R
import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.ad.strategy.AdTagManager
import com.transsion.ad.util.ViewUtil
import com.transsion.ad.view.AdTagView
import com.transsion.ad.middle.intercept.BaseInterceptMbAdActivity
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 15:30
 * @description:
 */
@Deprecated("使用 BiddingBuyOutInterstitialManager")
internal class NonInterstitialAdActivity : BaseInterceptMbAdActivity() {


    private var tvCd: AppCompatTextView? = null
    private var tvClose: ConstraintLayout? = null
    private var viewCd: LinearLayoutCompat? = null
    private var tvAudioContainer: ConstraintLayout? = null
    private var tvAudio: AppCompatImageView? = null

    /**
     * 是否打开视频的声音
     */
    private var mIsMute: Boolean = true


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        tvCd = findViewById(R.id.tvCd)
        viewCd = findViewById(R.id.viewCd)
        tvAudio = findViewById(R.id.tvAudio)
        tvAudioContainer = findViewById(R.id.tvAudioContainer)

        tvClose = findViewById(R.id.tvClose)
        tvClose?.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }

        tvAudioContainer?.setOnClickListener {
            AdLogger.logSdkSplash("${javaClass.simpleName} --> playVideo() --> 点击了音频按钮")
            // 设置静音
            mIsMute = setMute()
            setVolumeImage()
        }
        findViewById<AdTagView>(R.id.adIcon)?.apply {
            AdTagManager.handleForAdTagView(this)
        }
    }

    /**
     * 曝光检测
     */
    override fun getVisibilityView(): View? {
        val rlRoot = findViewById<ConstraintLayout>(R.id.rlRoot)
        return rlRoot
    }

    override fun setAdContentView(): Int = R.layout.activity_non_interstitial_ad

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun setAdClick() {
        ViewUtil.multipleClickListener(
            findViewById<FrameLayout>(R.id.view),
        ) {
            adClick()
        }
    }

    override fun getAdDestroyIntent(): Intent =
        Intent(NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_DESTROY_INTERSTITIAL)

    override fun getAdShowIntent(): Intent = Intent(
        NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_SHOW_INTERSTITIAL
    )

    override fun getAdImageView(): ImageView? = findViewById(R.id.ivAd)

    override fun getAdTextureView(): TextureView? = findViewById(R.id.textureView)

    override fun getCountDownTimes(): Int = SceneGlobalConfig.getInterstitialCd()

    override fun refreshCountDownView(i: Int) {
        if (i == getCountDownTimes()) {
            tvClose?.isClickable = false
            tvClose?.visibility = View.GONE

            viewCd?.visibility = View.VISIBLE
        }
        AdLogger.logSdkIntercept("${javaClass.simpleName} --> refreshCountDownView() --> i = $i -- getCountDownTimes() = ${getCountDownTimes()}")
        // 倒计时开始了
        val str = "$i"
        tvCd?.text = str
        // i= 1 的时候，skip 可点击
        if (i == 0) {
            tvClose?.isClickable = true
            tvClose?.visibility = View.VISIBLE

            tvCd?.visibility = View.GONE
            tvCd?.setTextColor(Color.parseColor("#92969E"))
        }
    }

    /**
     * 设置音频按钮的Icon
     */
    private fun setVolumeImage() {
        if (mIsMute) {
            tvAudio?.setImageResource(R.mipmap.ad_volumeoff)
        } else {
            tvAudio?.setImageResource(R.mipmap.ad_volumeon)
        }
    }

    override fun showCloseAdDialog() {}
    override fun onAdCompletion() {}

    override fun changeAudioIconContainer(showAudioIcon: Boolean) {
        tvAudioContainer?.visibility = if (showAudioIcon) {
            View.VISIBLE
        } else {
            View.GONE
        }
    }

}