package com.transsion.ad.middle.intercept.interstitial

import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.middle.intercept.BaseWrapperAdManager
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.middle.intercept.BaseNonAdManager
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 14:42
 * @description: 插屏加载对象是一个单例
 * 1.可以预加载
 * 2.加载成功之后展示
 * 3.直接展示 （如果没有资源的话回调失败并同步加载）
 * 4. 调用showAd() 之后一定要调用destroy()
 */
@Deprecated("使用 BiddingBuyOutInterstitialManager")
object WrapperInterstitialAdManager : BaseWrapperAdManager() {

    private var isInterceptFinalAd = false

    override fun onAdDestroy(sceneId: String?) {
        HiSavanaInterstitialAdManager.getManager(sceneId)?.destroy()
        getNonAdManager().destroy()
    }

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun loadHiSavanaAd(sceneId: String, listener: WrapperAdListener?) {
        HiSavanaInterstitialAdManager.getManager(sceneId)?.setListener(listener)?.load() ?: run {
            loadAdShowFinal()
        }
    }

    override fun showHiSavanaAd(
        sceneId: String,
        listener: WrapperAdListener?,
        ctxMap: Map<String, Any>?
    ) {
        HiSavanaInterstitialAdManager.getManager(sceneId)?.setListener(listener)?.showAd(ctxMap) ?: run {
            showInnerAdShowFinal()
        }
    }

    override fun showMbAd(sceneId: String, adPlans: AdPlans?, listener: WrapperAdListener?) {
        getNonAdManager().setListener(listener).showAd(adPlans, sceneId)
    }

    override fun getNonAdManager(): BaseNonAdManager = NonInterstitialAdManager()

    override fun onLoad() {
        super.onLoad()
        isInterceptFinalAd = false
    }

    override fun onError(p0: TAdErrorCode?) {
        if (isInterceptFinalAd) {
            mListener?.onError(p0)
        } else {
            super.onError(p0)
        }
        isInterceptFinalAd = false
    }

    fun setInterceptFinal(b: Boolean) {
        isInterceptFinalAd = b
    }
}