package com.transsion.ad.middle.intercept.video

import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import androidx.appcompat.widget.AppCompatTextView
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.fragment.app.FragmentManager
import com.transsion.ad.AdLogger
import com.transsion.ad.R

/**
 * @author: zhangxinbing
 * @date : 2024/7/26 17:14
 * @description:
 */
@Deprecated("使用 BiddingInterstitialManager")
class CloseAdDialog : DialogFragment(R.layout.dialog_video_cloase_ad_layout) {

    private var mResumeAdCallback: (() -> Unit?)? = null
    private var mCloseAdCallback: (() -> Unit?)? = null
    private var tvResumeAd: AppCompatTextView? = null
    private var tvCloseAd: AppCompatTextView? = null

    fun getClassTag(): String = javaClass.simpleName


    // ==============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NORMAL, R.style.ad_center_DialogStyle)
        AdLogger.logSdkIntercept("${getClassTag()} --> onCreate() --> 观看广告弹窗")
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        dialog?.window?.setLayout(
            WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT
        )
        // 展示的位置
        dialog?.window?.setGravity(Gravity.CENTER)
        dialog?.setCancelable(false)

        // 关闭广告
        tvCloseAd = view.findViewById(R.id.tvCloseAd)
        tvCloseAd?.setOnClickListener {
            mCloseAdCallback?.invoke()
        }

        // 继续观看
        tvResumeAd = view.findViewById(R.id.tvResumeAd)
        tvResumeAd?.setOnClickListener {
            dismissAllowingStateLoss()
            mResumeAdCallback?.invoke()
        }
    }

    fun setCallback(closeAdCallback: () -> Unit, resumeAdCallback: () -> Unit): CloseAdDialog {
        mCloseAdCallback = closeAdCallback
        mResumeAdCallback = resumeAdCallback
        return this
    }


    // =============================================================================================


    fun showDialog(context: Context?, tag: String?) {
        if (context is FragmentActivity && !context.isFinishing && !context.isDestroyed) {
            try {
                showDialog(context.supportFragmentManager, tag)
            } catch (e: IllegalStateException) {
                e.printStackTrace()
            } catch (e: java.lang.Exception) {
                e.printStackTrace()
            }
        }
    }

    fun showDialog(fragment: Fragment, tag: String?) {
        try {
            show(fragment.childFragmentManager, tag)
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    private fun showDialog(fragmentManager: FragmentManager, tag: String?) {
        try {
            fragmentManager.executePendingTransactions()
            if (this.isAdded || fragmentManager.findFragmentByTag(tag) != null) {
                return
            }
            show(fragmentManager, tag)
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }


}