package com.transsion.ad.middle.intercept.video

import android.app.Activity
import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.mediation.ad.TBaseAd
import com.hisavana.mediation.ad.TRewardedAd
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.AdContextManager
import com.transsion.ad.middle.intercept.BaseInterceptHiSavanaAdManager
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 14:42
 * @description: Hi 激励视频广告
 */
@Deprecated("使用 BiddingInterstitialManager")
internal class HiSavanaVideoAdManager(private val mSceneId: String) :
    BaseInterceptHiSavanaAdManager(mSceneId) {

    companion object {

        /**
         * 因为所有的HiSavana 广告位ID都是服务端下发的,所以客户端会有多个对象
         */
        private val mAdMap by lazy {
            HashMap<String, HiSavanaVideoAdManager>()
        }

        /**
         * 通过广告位ID获取广告加载对象
         */
        fun getManager(sceneId: String?): HiSavanaVideoAdManager? {
            if (TextUtils.isEmpty(sceneId)) {
                return null
            }
            val hiSavanaPlacementId = SceneCommonConfig.getHiSavanaPlacementId(sceneId) ?: return null
            var manager = mAdMap[hiSavanaPlacementId]
            if (null == manager) {
                manager = HiSavanaVideoAdManager(sceneId ?: "")
                mAdMap[hiSavanaPlacementId] = manager
            }
            return manager
        }
    }


    // =============================================================================================


    /*** 广告加载对象*/
    private var tTVideoAd: TRewardedAd? = null

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_VIDEO

    override fun getAdInstance(): TBaseAd<*>? {
        // 如果对象不存在，那就创建新的
        if (null == tTVideoAd) {
            val hiSavanaPlacementId = SceneCommonConfig.getHiSavanaPlacementId(mSceneId)
            tTVideoAd = TRewardedAd(Utils.getApp(), hiSavanaPlacementId)
            tTVideoAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdListener(this).build()
            )
        }
        return tTVideoAd
    }

    override fun show(topActivity: Activity, ctxMap: Map<String, Any>?) {
        if (AdContextManager.isDangerGenre(ctxMap)) {
            tTVideoAd?.setContainVulgarContent(true)
        }
        tTVideoAd?.show(topActivity)
    }

    override fun reset() {
        tTVideoAd = null
    }

}