package com.transsion.ad.middle.intercept.video

import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.view.TextureView
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.AppCompatTextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.bumptech.glide.Glide
import com.google.android.material.imageview.ShapeableImageView
import com.transsion.ad.AdLogger
import com.transsion.ad.R
import com.transsion.ad.middle.intercept.BaseInterceptMbAdActivity
import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.ad.util.ViewUtil
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author: zhangxinbing
 * @date : 2023/12/12 19:20
 * @description:
 */
@Deprecated("使用 BiddingInterstitialManager")
internal class NonVideoAdActivity : BaseInterceptMbAdActivity() {

    private var tvCd: AppCompatTextView? = null
    private var ivVolume: AppCompatImageView? = null
    private var ivClose: AppCompatImageView? = null
    private var tvAvatar: ShapeableImageView? = null
    private var tvTitle: AppCompatTextView? = null
    private var tvDesc: AppCompatTextView? = null
    private var tvBtn: AppCompatTextView? = null

    private var isCanClickClose = false


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        tvCd = findViewById(R.id.tvCd)

        // 关闭按钮
        ivClose = findViewById(R.id.ivClose)
        ivClose?.setOnClickListener {
            if (isCanClickClose.not()) {
                // 只有在最后10秒的时候才能点击
                AdLogger.logSdkIntercept("${javaClass.simpleName} --> setOnClickListener() --> 只有在最后10秒的时候才能点击")
                return@setOnClickListener
            }
            onBackPressedDispatcher.onBackPressed()
        }

        // 声音开关
        ivVolume = findViewById(R.id.ivVolume)
        ivVolume?.setOnClickListener {
            if (setMute()) {
                ivVolume?.setImageResource(R.mipmap.ad_video_04)
            } else {
                ivVolume?.setImageResource(R.mipmap.ad_video_02)
            }
        }

        initAdData()
    }


    // =============================================================================================


    override fun setAdContentView(): Int = R.layout.activity_non_video_ad

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_VIDEO

    override fun setAdClick() {
        ViewUtil.multipleClickListener(
            findViewById<FrameLayout>(R.id.textureView),
            findViewById<FrameLayout>(R.id.clAdEndLayout)
        ) {
            adClick()
        }
    }

    override fun getAdDestroyIntent(): Intent =
        Intent(NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_DESTROY_VIDEO)

    override fun getAdShowIntent(): Intent = Intent(
        NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_SHOW_VIDEO
    )

    override fun getAdImageView(): ImageView? = null

    override fun getAdTextureView(): TextureView = findViewById(R.id.textureView)

    override fun getCountDownTimes(): Int = SceneGlobalConfig.getVideoCd()

    override fun getVisibilityView(): View? {
        val rlRoot = findViewById<ConstraintLayout>(R.id.rlRoot)
        return rlRoot
    }

    override fun refreshCountDownView(i: Int) {
        AdLogger.logSdkIntercept("${javaClass.simpleName} --> refreshCountDownView() --> i = $i -- getCountDownTimes() = ${getCountDownTimes()}")

        if (i <= 10) {
            isCanClickClose = true
            ivClose?.setImageResource(R.mipmap.ad_video_01)
        } else {
            ivClose?.setImageResource(R.mipmap.ad_video_03)
        }

        if (i == getCountDownTimes()) {
            tvCd?.visibility = View.VISIBLE
        }
        // 倒计时开始了
        val str = "Reward in ${i}s"
        tvCd?.text = str
        // i= 1 的时候，skip 可点击
        if (i == 0) {
            tvCd?.visibility = View.GONE
            ivVolume?.visibility = View.GONE
            onRewarded()
        }
    }


    // =============================================================================================


    private fun initAdData() {
        // 广告信息
        tvAvatar = findViewById(R.id.tvAvatar)
        tvTitle = findViewById(R.id.tvTitle)
        tvDesc = findViewById(R.id.tvDesc)
        tvBtn = findViewById(R.id.tvBtn)

        kotlin.runCatching {
            tvAvatar?.let {
                if (TextUtils.isEmpty(mAdPlan?.advertiserAvatarPath)) {
                    Glide.with(this).load(mAdPlan?.advertiserAvatar).into(it)
                } else {
                    Glide.with(this).load(mAdPlan?.advertiserAvatarPath).into(it)
                }
            }

            tvTitle?.text = mAdMaterialList?.title
            tvDesc?.text = mAdMaterialList?.desc
            tvBtn?.text = mAdMaterialList?.buttonText
        }
    }


    /**
     * 获得激励之后需要发本地广播的
     */
    private fun onRewarded() {
        val intent = Intent(NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_REWARDED_VIDEO)
        // 添加额外的数据（如果需要）
        intent.putExtra("key", "value")
        LocalBroadcastManager.getInstance(this).sendBroadcast(intent)
    }

    override fun showCloseAdDialog() {

        if (isCanClickClose.not()) {
            // 只有在最后10秒的时候才能点击
            AdLogger.logSdkIntercept("${javaClass.simpleName} --> showCloseAdDialog() --> 只有在最后10秒的时候才能展示")
            return
        }

        setShowCloseAdDialog(true)
        pause()
        CloseAdDialog().setCallback(closeAdCallback = {
            closeAd()
        }, resumeAdCallback = {
            setShowCloseAdDialog(false)
            play()
        }).showDialog(this, "CloseAdDialog")
    }

    override fun onAdCompletion() {
        findViewById<ConstraintLayout>(R.id.clAdEndLayout).visibility = View.VISIBLE
        val tvAdAvatar = findViewById<ShapeableImageView>(R.id.tvAdAvatar)
        val ivAdClose = findViewById<AppCompatImageView>(R.id.ivAdClose)
        ivAdClose.setOnClickListener {
            closeAd()
        }
        val tvAdTitle = findViewById<AppCompatTextView>(R.id.tvAdTitle)
        val tvAdDesc = findViewById<AppCompatTextView>(R.id.tvAdDesc)
        val tvAdBtn = findViewById<AppCompatTextView>(R.id.tvAdBtn)

        // 如果按钮没有文案的话就隐藏
        if (TextUtils.isEmpty(mAdMaterialList?.buttonText)) {
            tvAdBtn.visibility = View.GONE
        }

        kotlin.runCatching {
            tvAdAvatar?.let {
                if (TextUtils.isEmpty(mAdPlan?.advertiserAvatarPath)) {
                    Glide.with(this).load(mAdPlan?.advertiserAvatar).into(it)
                } else {
                    Glide.with(this).load(mAdPlan?.advertiserAvatarPath).into(it)
                }
            }

            tvAdTitle?.text = mAdMaterialList?.title
            tvAdDesc?.text = mAdMaterialList?.desc
            tvAdBtn?.text = mAdMaterialList?.buttonText
        }
    }

    override fun changeAudioIconContainer(showAudioIcon: Boolean) {

    }

}