package com.transsion.ad.middle.intercept.video

import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.middle.intercept.BaseWrapperAdManager
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.middle.intercept.BaseNonAdManager
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 14:42
 * @description: 激励视频加载对象是一个单例
 * 1.可以预加载
 * 2.加载成功之后展示
 * 3.直接展示 （如果没有资源的话回调失败并同步加载）
 * 4. 调用showAd() 之后一定要调用destroy()
 */
@Deprecated("使用 BiddingInterstitialManager")
object WrapperVideoAdManager : BaseWrapperAdManager() {

    override fun onAdDestroy(sceneId: String?) {
        HiSavanaVideoAdManager.getManager(sceneId)?.destroy()
        getNonAdManager().destroy()
    }

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_VIDEO

    override fun loadHiSavanaAd(sceneId: String, listener: WrapperAdListener?) {
        HiSavanaVideoAdManager.getManager(sceneId)?.setListener(listener)?.load() ?: run {
            // 加载兜底包断广告
            loadAdShowFinal()
        }
    }

    override fun showHiSavanaAd(
        sceneId: String, listener: WrapperAdListener?, ctxMap: Map<String, Any>?
    ) {
        HiSavanaVideoAdManager.getManager(sceneId)?.setListener(listener)?.showAd(ctxMap) ?: run {
            showInnerAdShowFinal()
        }
    }

    override fun showMbAd(sceneId: String, adPlans: AdPlans?, listener: WrapperAdListener?) {
        getNonAdManager().setListener(listener).showAd(adPlans, sceneId)
    }

    override fun getNonAdManager(): BaseNonAdManager = NonVideoAdManager()

}