package com.transsion.ad.middle.nativead

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.mediation.ad.ViewBinder
import com.transsion.ad.strategy.AdLayoutProviderBean

/**
 * @author: zhangxinbing
 * @date : 2025/5/15 10:23
 * @description:
 */
abstract class AbsAdLayoutProvider {

    fun getAdLayoutProvider(viewContext: Context?): AdLayoutProviderBean {
        return AdLayoutProviderBean(
            layoutId = getLayoutId(),                           // layout id
            layout = getAdLayout(viewContext),                  // LayoutInflater View
            mediaId = getMediaId(),                             // TMediaView
            titleId = getTitleId(),                             // TextView
            iconId = getIconId(),                               // TIconView
            callToActionId = getCallToActionId(),               // TextView
            descriptionId = getDescriptionId(),                 // TextView

            adChoicesView = getAdChoicesView(),                 // TAdChoicesView
            adStoreMarkView = getAdStoreMarkView(),             // TStoreMarkView
            adCloseView = getAdCloseView(),                     // TAdCloseView

            ratingId = getRatingId(),                           // 评分 TODO
            priceId = getPriceId(),                             // 价格 TODO
            sponsoredId = getSponsoredId(),                     // 赞助 TODO
            likesId = getLikesId(),                             // 喜欢 TODO
            downloadsId = getDownloadsId(),                     // 下载数量 TODO
            adDisclaimerView = getAdDisclaimerView(),           // 免责声明 TODO
            adBadgeView = getAdBadgeView(),                     // 徽章 TODO
            domainId = getDomainId(),                           // 领域 TODO
            feedbackId = getFeedbackId(),                       // 反馈 TODO

            apkSizeId = getApkSizeId(),                         // APK 大小 TextView
            burlBgId = getBurlBgId(),                           // 高斯模糊背景 ImageView
            adTagId = getAdTagId(),                             // AdTagView
        )
    }


    // =============================================================================================


    fun getAdLayout(viewContext: Context?): View {
        // 如果没有Icon那就不展示了
        return LayoutInflater.from(viewContext ?: Utils.getApp()).inflate(getLayoutId(), null)
    }

    abstract fun getLayoutId(): Int
    abstract fun getTitleId(): Int?
    abstract fun getMediaId(): Int?
    abstract fun getCallToActionId(): Int?
    abstract fun getDescriptionId(): Int?
    abstract fun getAdChoicesView(): Int?

    abstract fun getHiViewBinder(
        adLayoutProvider: AdLayoutProviderBean, mNativeInfo: TAdNativeInfo?
    ): ViewBinder

    abstract fun getAdStoreMarkView(): Int?
    open fun getIconId(): Int? = null
    open fun getRatingId(): Int? = null
    open fun getPriceId(): Int? = null
    open fun getSponsoredId(): Int? = null
    open fun getLikesId(): Int? = null
    open fun getDownloadsId(): Int? = null
    open fun getAdDisclaimerView(): Int? = null
    open fun getAdBadgeView(): Int? = null
    open fun getAdCloseView(): Int? = null
    open fun getDomainId(): Int? = null
    open fun getFeedbackId(): Int? = null
    open fun getApkSizeId(): Int? = null
    open fun getBurlBgId(): Int? = null
    open fun getAdTagId(): Int? = null
}