package com.transsion.ad.middle.nativead

import android.app.Activity
import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.view.Gravity
import android.view.LayoutInflater
import android.view.TextureView
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.blankj.utilcode.util.SizeUtils
import com.bumptech.glide.Glide
import com.hisavana.mediation.ad.ViewBinder
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.R
import com.transsion.player.MediaSource
import com.transsion.player.config.VodConfig
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.orplayer.ORPlayer
import com.transsion.player.orplayer.PlayError
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.intercept.NonAdShowedTimesManager
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.strategy.AdClickManager
import com.transsion.ad.strategy.MeasureManager
import com.transsion.ad.view.blur.BlurTransformation
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.monopoly.plan.AdPlanUtil


/**
 * @author: zhangxinbing
 * @date : 2023/12/14 14:00
 * @description: 非标原生广告View 用于展示非标原生广告
 */
@Deprecated("")
internal class BuyOutNativeView : FrameLayout, MeasureManager.ViewVisibilityListener {

    /**
     * 是否打开视频的声音
     */
    private var mIsMute: Boolean = true

    private var mIsShowVolumeIcon: Boolean = true

    /**
     * 场景调用的时候传进来的场景ID
     */
    private var mSceneId: String? = null

    /**
     * 广告计划信息
     */
    private var mAdPlans: AdPlans? = null

    /**
     * 非标广告素材信息
     */
    private var mAdMaterialList: AdMaterialList? = null

    /**
     * 视频播放器
     */
    private var mOrPlayer: ORPlayer? = null

    /**
     * 是否开启背景模糊
     */
    private var enableBgBlur: Boolean? = null

    private var mCallback: WrapperAdListener? = null

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context, attrs, defStyleAttr
    )


    // ============================ 曝光检测 =========================================================


    /***广告开始展示的时间 时间戳 毫秒*/
    private var showTime = 0L

    /***是否已经上报过一次曝光了*/
    private var isReportAdDisplay = false

    override fun onVisibilityChanged(isVisible: Boolean) {
        //Logger.d(javaClass.simpleName, "onVisibilityChanged isVisible = $isVisible")
        if (isVisible) {
            play()
        } else {
            pause()
        }
    }

    private fun play() {
        // 开始展示的时间
        if (showTime == 0L) {
            showTime = System.currentTimeMillis()
        }

        // 视频状态处理
        if (mOrPlayer?.isPlaying() == false) {
            mOrPlayer?.play()
        }

        // 曝光上报
        if (!isReportAdDisplay) {
            isReportAdDisplay = true
            AdReportProvider.display(
                sceneId = mSceneId,
                adPlanId = mAdPlans?.id,
                adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_NATIVE,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
                psId = AdPlanUtil.getPsId(mAdPlans)
            )
            AdLogger.logSdkNative(
                "${javaClass.simpleName} --> 广告展示 --> sceneId = $mSceneId --> isAdShowFinal = ${
                    MbAdShowLevel.isAdShowLevel(
                        mAdPlans
                    )
                }", writeToFile = false
            )
            saveShowCount()
        }
    }

    private fun pause() {
        mOrPlayer?.pause()
        // 播放时长上报
        reportShowTime()
    }

    override fun getVisibilityView(): View {
        return this
    }

    override fun getVisibilityThreshold(): Double = 10.0


    // =============================================================================================


    /**
     * 资源回收
     */
    fun destroy() {
        AdLogger.logSdkNative(
            "${getClassTag()} --> destroy() --> sceneId = $mSceneId --> isAdShowFinal = ${
                MbAdShowLevel.isAdShowLevel(
                    mAdPlans
                )
            }", writeToFile = false
        )
        removeAllViews()
        // 资源回收
        mOrPlayer?.release()
        // 添加检测
        MeasureManager.removeSession(this)

        mCallback = null

        // 资源回收之前需要判断一下是否需要上报一下展示时长埋点
        reportShowTime()

        // 监听 WebView的生命周期
        //IWebViewActivityStateListener.reset()
    }

    /**
     * 绑定原生广告
     */
    fun bindNativeView(
        sceneId: String?,
        adPlans: AdPlans?,
        viewBinder: ViewBinder?,
        isMute: Boolean = true,
        isShowVolumeIcon: Boolean = true
    ) {
        mIsMute = isMute
        mIsShowVolumeIcon = isShowVolumeIcon
        mSceneId = sceneId

        if (adPlans != null && viewBinder != null) {
            val viewRoot = if (null == viewBinder.layout) {
                LayoutInflater.from(context).inflate(viewBinder.layoutId, this, false)
            } else {
                viewBinder.layout
            }

            // 展示数据
            showData(viewRoot, adPlans, viewBinder)

            // 组装View
            addView(viewRoot)

            // 添加检测
            MeasureManager.addSession(this@BuyOutNativeView)
        }
    }

    /**
     * 是否开启背景模糊
     */
    fun enableBgBlur(enableBgBlur: Boolean?) {
        this.enableBgBlur = enableBgBlur
    }

    fun setCallback(callback: WrapperAdListener?) {
        mCallback = callback
    }


    // =============================================================================================


    private fun showData(
        viewRoot: View?, adPlans: AdPlans, viewBinder: ViewBinder
    ) {

        // 修复线上问题
        // 在Android中使用Glide加载图片时，如果传入的context是view的context，可能会导致上述的IllegalArgumentException。
        // 这是因为view的context可能与Activity的生命周期不同步。
        // Exception java.lang.IllegalArgumentException: You cannot start a load for a destroyed activity
        // at com.bumptech.glide.manager.RequestManagerRetriever.assertNotDestroyed (RequestManagerRetriever.java:353)
        // at com.bumptech.glide.manager.RequestManagerRetriever.get (RequestManagerRetriever.java:153)
        // at com.bumptech.glide.manager.RequestManagerRetriever.get (RequestManagerRetriever.java:133)
        // at com.bumptech.glide.Glide.with (Glide.java:818)
        // at com.transsion.wrapperad.middle.nativead.NonNativeView.showData (NonNativeView.kt:266)
        if ((context as? Activity)?.isDestroyed == true) {
            AdLogger.logSdkNative(
                "${javaClass.simpleName} --> 当前Activity销毁，广告就不需要展示了",
                writeToFile = false
            )
            return
        }

        // 目前规定一个计划只有一个素材
        mAdMaterialList = adPlans.adMaterialList?.get(0)
        // 广告计划
        mAdPlans = adPlans

        // 设置标题
        viewRoot?.findViewById<TextView>(viewBinder.titleId)?.apply {
            text = mAdMaterialList?.title
        }

        // 设置描述
        viewRoot?.findViewById<TextView>(viewBinder.descriptionId)?.apply {
            text = mAdMaterialList?.desc
        }

        // 按钮文案
        viewRoot?.findViewById<TextView>(viewBinder.callToActionId)?.apply {
            if (TextUtils.isEmpty(mAdMaterialList?.buttonText)) {
                mAdMaterialList?.buttonText = "GO"
            }
            text = mAdMaterialList?.buttonText
            setOnClickListener {
                clickAd()
            }
        }
        // viewRoot?.findViewById<TextView>(viewBinder.callToActionId)?.setOnClickListener {
        viewRoot?.setOnClickListener {
            clickAd()
        }

        // 广告主头像
        viewRoot?.findViewById<FrameLayout>(viewBinder.iconId)?.apply {
            removeAllViews()
            visibility = View.VISIBLE
            val iconView = ImageView(context)
            iconView.scaleType = ImageView.ScaleType.CENTER_INSIDE

            if (TextUtils.isEmpty(adPlans.advertiserAvatarPath)) {
                Glide.with(context).load(adPlans.advertiserAvatar).fitCenter().into(iconView)
            } else {
                Glide.with(context).load(adPlans.advertiserAvatarPath).fitCenter().into(iconView)
            }

            addView(iconView)
        }
        // 因为有些广告没有广告主头像，所以这里需要判断一下
        // TODO ========== 待处理
//        val nativeAdIcon = viewRoot?.findViewById<MaskLayout>(R.id.maskLayoutIcon)
//        nativeAdIcon?.visibility = View.VISIBLE

        // 展示媒体内容
        if (mAdMaterialList?.type == AdMaterialList.NON_AD_TYPE_TEXT) {
            showImage(viewRoot, viewBinder, mAdMaterialList)
        } else {
            playVideo(viewRoot, viewBinder, mAdMaterialList)
        }
    }

    /**
     * 广告点击事件
     */
    private fun clickAd() {
        // 广告点击事件处理
        AdClickManager.adClick(
            deeplink = mAdMaterialList?.deeplink, h5Url = mAdMaterialList?.h5Link, adPlan = mAdPlans
        )

        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> 广告点击了 --> sceneId = $mSceneId --> isAdShowFinal = ${
                MbAdShowLevel.isAdShowLevel(
                    mAdPlans
                )
            }", writeToFile = false
        )
        // 点击埋点曝光
        AdReportProvider.adClick(
            sceneId = mSceneId,
            adPlanId = mAdPlans?.id,
            adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
            adId = mAdMaterialList?.id,
            adType = MbAdType.MB_AD_TYPE_NATIVE,
            isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
            psId = AdPlanUtil.getPsId(mAdPlans)
        )

        // 回调出去
        mCallback?.onClicked(MbAdSource.MB_AD_SOURCE_BUY_OUT)
    }


    /**
     * 展示图片
     */
    private fun showImage(
        viewRoot: View?, viewBinder: ViewBinder, adMaterialList: AdMaterialList?
    ) {
        // 主图 -- 这里需要判断是视频还是图片 -- 测试 先开发图片
        viewRoot?.findViewById<FrameLayout>(viewBinder.mediaId)?.apply {
            removeAllViews()

            // 模糊背景
            if (enableBgBlur == true) {
                val imageViewBlur = ImageView(context)
                imageViewBlur.scaleType = ImageView.ScaleType.CENTER_CROP
                // 如果本地地址是空的，那就不使用线上地址在线加载
                val path = if (TextUtils.isEmpty(adMaterialList?.image?.path)) {
                    adMaterialList?.image?.url
                } else {
                    adMaterialList?.image?.path
                }
                Glide.with(context).load(path).transform(BlurTransformation(25)).into(imageViewBlur)
                // 全屏展示
                addView(imageViewBlur)
            }

            // 大图
            val imageView = ImageView(context)
            imageView.scaleType = ImageView.ScaleType.FIT_CENTER
            // 如果本地地址是空的，那就不使用线上地址在线加载
            val pathImage = if (TextUtils.isEmpty(adMaterialList?.image?.path)) {
                adMaterialList?.image?.url
            } else {
                adMaterialList?.image?.path
            }
            Glide.with(context).load(pathImage).into(imageView)
            // 全屏展示
            addView(imageView)
        }
    }

    /**
     * 播放视频
     */
    private fun playVideo(
        viewRoot: View?, viewBinder: ViewBinder, adMaterialList: AdMaterialList?
    ) {

        // AdLogger.log("${javaClass.simpleName} --> playVideo() --> 开始播放视频广告 --> start")

        // 主图 -- 这里需要判断是视频还是图片 -- 测试 先开发图片
        viewRoot?.findViewById<FrameLayout>(viewBinder.mediaId)?.apply {
            removeAllViews()
            // 创建展示视频的View
            val textureView = TextureView(context)
            addView(textureView)

            // 控制音频的按钮
            if (mIsShowVolumeIcon) {
                val imageView = ImageView(this.context)
                imageView.tag = "adVolumeImage"
                setVolumeImage(imageView)
                val layoutParams = LayoutParams(SizeUtils.dp2px(24f), SizeUtils.dp2px(24f))
                // 横屏播放开始/暂停/结束位置广告，静音按钮位置单独适配
//                if (mSceneId == SceneId.SCENE_LANDSCAPE_START || mSceneId == SceneId.SCENE_LANDSCAPE_PAUSE || mSceneId == SceneId.SCENE_LANDSCAPE_END) {
//                    layoutParams.gravity = Gravity.END or Gravity.BOTTOM
//                    layoutParams.bottomMargin = SizeUtils.dp2px(30f)
//                    layoutParams.marginEnd = SizeUtils.dp2px(8f)
//                } else {
                layoutParams.gravity = Gravity.END or Gravity.TOP
                layoutParams.topMargin = SizeUtils.dp2px(8f)
                layoutParams.marginEnd = SizeUtils.dp2px(8f)
//                }
                imageView.setOnClickListener {
                    AdLogger.logSdkNative(
                        "${javaClass.simpleName} --> playVideo() --> 点击了音频按钮",
                        writeToFile = false
                    )
                    // 设置静音
                    mIsMute = mIsMute.not()
                    mOrPlayer?.setMute(mIsMute)
                    setVolumeImage(imageView)
                }
                addView(imageView, layoutParams)
            }

            // 创建播放器
            mOrPlayer = ORPlayer.Builder(context)
                .vodConfig(VodConfig(clearFrameWhenStop = false, openAudioFocus = false)).builder()
                .apply {
                    setMute(mIsMute)
                    setTextureView(textureView)
                    setLooping(true)
                    setPlayerListener(object : IPlayerListener {

                        override fun onPlayError(
                            errorInfo: PlayError, mediaSource: MediaSource?
                        ) {
                            super.onPlayError(errorInfo, mediaSource)
                            AdLogger.logSdkNative(
                                "${javaClass.simpleName} --> playVideo() --> onPlayError() --> errorInfo = $errorInfo -- sceneId = $mSceneId",
                                writeToFile = false
                            )
                        }

                        override fun onPrepare(mediaSource: MediaSource?) {
                            super.onPrepare(mediaSource)
                            play()
                        }

                    })
                }
            //mOrPlayer?.setDataSource(DOWNLOAD_FILE_PATH_OLD?.absolutePath + File.separator + "non_ad" + File.separator + "Trailer—The_Perfect_Date.mp4")
            if (TextUtils.isEmpty(adMaterialList?.video?.path)) {
                mOrPlayer?.setDataSource(
                    MediaSource(
                        adMaterialList?.video?.url ?: "", adMaterialList?.video?.url ?: ""
                    )
                )
            } else {
                mOrPlayer?.setDataSource(
                    MediaSource(
                        adMaterialList?.video?.path ?: "", adMaterialList?.video?.path ?: ""
                    )
                )
            }

            mOrPlayer?.prepare()
        }
    }

    /**
     * 设置音频按钮的Icon
     */
    private fun setVolumeImage(imageView: ImageView) {
        if (mIsMute) {
            imageView.setImageResource(R.mipmap.ad_volumeoff)
        } else {
            imageView.setImageResource(R.mipmap.ad_volumeon)
        }
    }

    /**
     * 保存当前展示次数
     */
    private fun saveShowCount() {
        NonAdShowedTimesManager.saveShowedTimes(mAdPlans)
    }

    /**
     * 上报累计展示埋点
     */
    private fun reportShowTime() {
        if (showTime > 0) {
            // 上报曝光时长
            AdReportProvider.adShowTime(
                sceneId = mSceneId,
                adPlanId = mAdPlans?.id,
                displayTime = (System.currentTimeMillis() - showTime),
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_NATIVE,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans)
            )
            showTime = 0
        }
    }
}