package com.transsion.ad.middle.nativead

import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.common.interfacz.TAdListener
import com.hisavana.mediation.ad.TNativeAd
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.hi.HiSavanaAdManager
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import java.util.LinkedList
import java.util.concurrent.ConcurrentLinkedDeque

/**
 * @author: zhangxinbing
 * @date : 2023/12/13 10:36
 * @description: 加载HiSavana原生广告 -- 返回TAdNativeInfo
 */
@Deprecated("")
class HiSavanaNativeAdManager(private var mPlacementId: String) : TAdListener() {

    companion object {

        /**
         * 当前Map存储所有广告加载缓存池
         */
        private val map by lazy {
            mutableMapOf<String, HiSavanaNativeAdManager>()
        }

        /**
         * 通过广告位ID -- 获取广告池 -- 在缓存池里面获取广告
         */
        fun getNativeManager(placementId: String?): HiSavanaNativeAdManager? {
            if (placementId == null) {
                return null
            }

            if (placementId.isEmpty()) {
                return null
            }

            var manager = map[placementId]
            if (null == manager) {
                val adNativeManager = HiSavanaNativeAdManager(placementId)
                map[placementId] = adNativeManager
                manager = adNativeManager
            }
            return manager
        }
    }


    // =============================================================================================


    /**
     * 缓存队列 --> 在存入的时候做了降序排序 --> 添加、移除
     */
    private val nativeInfoList = LinkedList<TAdNativeInfo>()

    /**
     * 任务队列 --> 添加、移除、遍历
     */
    private val taskList = ConcurrentLinkedDeque<WrapperAdListener>()

    /**
     * 广告加载对象 负责广告的加载
     */
    private var tNativeAd: TNativeAd? = null

    /**
     * 当前正在请求中
     */
    private var isLoading = false

    /**
     * 广告点击事件处理
     */
    private val callbackList = ConcurrentLinkedDeque<WrapperAdListener>()


    // ============================广告SDK回调========================================================

    /**
     * 广告数据加载完成还未展示，此回调方法适用于Banner、Interstitial、Splash 和 preload 类型的Native广告
     *
     * 获取到广告之后保存到本地缓存池
     */
    override fun onLoad() {
        super.onLoad()
        // 获取到广告了修改状态
        isLoading = false

        // 将结果进行分发
        dispense()
    }

    /**
     * 请求过程中发生错误的回调
     */
    override fun onError(p0: TAdErrorCode?) {
        // 广告请求失败 --> 所有的请求失败或者设置到超时到了就会回调这个
        AdLogger.logSdkNative("${javaClass.simpleName} --> onError() --> p0 = $p0 -- mPlacementId = $mPlacementId")

        // 修改状态
        isLoading = false
        taskList.forEach {
            it.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_HISAVANA, "请求广告失败"))
        }
    }

    override fun onShow(source: Int) {
        // 广告展示成功回调
        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> onShow() --> source = $source", writeToFile = false
        )
    }

    override fun onNativeFeedShow(source: Int, tNativeInfo: TAdNativeInfo?) {
        super.onNativeFeedShow(source, tNativeInfo)
        // 扩展参数 --> 修复SDKNativeInfo和NativeAd的绑定 --> 上报
        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> onNativeFeedShow() --> source = $source -- pageName = ${tNativeInfo?.sceneId}",
            writeToFile = false
        )

        AdReportProvider.display(
            sceneId = getSceneId(tNativeInfo),
            adPlanId = "",
            adSource = source,
            adId = tNativeInfo?.adId,
            adType = MbAdType.MB_AD_TYPE_NATIVE,
            isAdShowFinal = false,
            psId = null
        )

        // 这里重置数据 -- 便于广告销毁的时候判断是否展示了
        tNativeInfo?.ext = ""
    }

    override fun onShowError(source: TAdErrorCode?) {
        super.onShowError(source)
        // 广告展示失败回调
        AdLogger.logSdkNativeE("${javaClass.simpleName} --> onShowError() --> source = $source")
    }

    override fun onClicked(source: Int) {
        // 广告点击回调
        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> onClicked() --> source = $source", writeToFile = false
        )
    }

    /**
     * TODO 新版本是native广告调onNativeFeedClicked，其他类型广告调onClicked 3.0.7.0
     */

    override fun onNativeFeedClicked(source: Int, tNativeInfo: TAdNativeInfo?) {
        super.onNativeFeedClicked(source, tNativeInfo)
        // 扩展参数 --> 修复SDKNativeInfo和NativeAd的绑定 --> 上报
        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> onNativeFeedClicked --> pageName = ${tNativeInfo?.sceneId}",
            writeToFile = false
        )

        AdReportProvider.adClick(
            sceneId = getSceneId(tNativeInfo),
            adPlanId = "",
            adSource = source,
            adId = tNativeInfo?.adId,
            adType = MbAdType.MB_AD_TYPE_NATIVE,
            isAdShowFinal = false,
            psId = null
        )

        taskList.forEach {
            it.onClicked(source)
        }
    }

    override fun onClosed(p0: Int) {
        // 广告关闭回调，并不是所有广告都会唤起此方法。
        AdLogger.logSdkNative("${javaClass.simpleName} --> onClosed --> ", writeToFile = false)
    }


    // ============================AdNativeManager内部逻辑============================================


    /**
     * 加载广告 --> 现在仅支持串行请求
     */
    private fun loadAd(mag: String = "") {
        // 如果没有初始化，那就不进行任何操作
        if (HiSavanaAdManager.isInitialized().not()) {
            taskList.forEach {
                it.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_HISAVANA, "广告SDK没有初始化"))
            }
            return
        }

        // 如果正在请求中那就return 这个isLoading 仅在SDK回调的onLoad和onError修改
        if (isLoading) {
            return
        }
        isLoading = true
        AdLogger.logSdkNative("${javaClass.simpleName} --> loadAd() --> mag = $mag")

        // 加载广告
        if (null == tNativeAd) {
            tNativeAd = TNativeAd(Utils.getApp(), mPlacementId)
            tNativeAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdListener(this).build()
            )
            AdLogger.logSdkNative(
                "${javaClass.simpleName} --> loadAd() --> mPlacementId = $mPlacementId --> create TNativeAd() =================== "
            )
        }
        tNativeAd?.loadAd()
    }

    /**
     * 分发结果
     */
    private fun dispense() {
        // getNativeAdInfo()	获取Native广告，返回一个List(2.6.8.+新增)
        // getNativeInfoSize()	获取当前可用的广告的数量(2.6.8.+新增)
        val nativeAdInfo = tNativeAd?.nativeAdInfo
        AdLogger.logSdkNative("${javaClass.simpleName} --> onLoad() -- 获取到的广告总数 -- size = ${nativeAdInfo?.size}")

        nativeAdInfo?.let {
            if (it.isNotEmpty()) {
                //  广告回来了 --> 如果都拒绝了那就保存到缓存池 --> 判断一下缓存池的阈值是否继续请求
                //               --> 有一个Callback需要立即展示广告 --> 将这个广告返回
                //                                              --> 判断一下是否还有Callback --> 有继续请求
                //                                                                        --> 没有Callback就判断缓存池阈值 是否需要继续加载

                // 如果是icon广告那就全部返回
                if (taskList.isNotEmpty()) {
                    // 将结果分发给每一个回调
                    while (taskList.isNotEmpty() && it.isNotEmpty()) {
                        // 将第一个返回
                        val tAdNativeInfo = it.removeAt(0)
                        taskList.removeFirst().onNativeInfoReady(tAdNativeInfo)
                    }

                    if (taskList.isNotEmpty()) {
                        loadAd("dispense() --> 还有任务没有获得返回，继续请求")
                    } else {
                        // ---- 如果都拒绝了再回走这个分支 --> 那就保存到缓存池 --> 判断一下缓存池是否达到阈值
                        // 保存到缓存池
                        nativeInfoList.addAll(it)
                        AdLogger.logSdkNative(
                            "${javaClass.simpleName} --> onLoad() --> 没有使用全部保存到缓存池 -- addAll(it) --> nativeInfoList.size = ${nativeInfoList.size}"
                        )

                        // sortByDescending：降序排序  --- sortBy：生序排序
                        nativeInfoList.sortByDescending { info ->
                            info.ecpmPrice
                        }

                        // 判断一下是否需要填满缓存池
                        // 如果配置了0 那就意味着当前是不缓存的
                        if (isUpperLimit().not()) {
                            loadAd("dispense() --> 缓存池没有达到阈值，继续请求")
                        } else {

                        }
                    }
                } else {
                    // 保存到缓存池
                    nativeInfoList.addAll(it)
                }
            } else {
                AdLogger.logSdkNativeE("${javaClass.simpleName} --> onLoad() --> 获取到的广告集合是空的 -- p0 = empty")
            }
        }
    }

    /**
     * 从缓存池获取NativeInfo --> nativeInfoList
     */
    private fun getNativeInfo(): TAdNativeInfo? {
        // 缓存池是空的
        if (nativeInfoList.isEmpty()) {
            return null
        }

        // 过期了
        val info = nativeInfoList.pop()
        if (info.isExpired) {
            // 释放资源 --> 继续从缓存池获取
            info.release()
            return getNativeInfo()
        }

        // 返回结果
        return info
    }

    /**
     * 缓存池是否达到阈值,大于等于阈值了说明广告有富余没有消费完
     * 如果配置了0那就意味着不开启缓存的能力
     */
    private fun isUpperLimit(): Boolean {
        val cacheUpperLimit = SceneGlobalConfig.getNativeCacheUpperLimit()
        val b = nativeInfoList.size >= cacheUpperLimit
        if (b) {
            AdLogger.logSdkNative(
                "${javaClass.simpleName} --> isUpperLimit() --- 达到阈值了 --> nativeInfoList.size = ${nativeInfoList.size} -- cacheUpperLimit = $cacheUpperLimit"
            )
        }
        return b
    }

    /**
     * 获取TAdNativeInfo里面的SceneId
     */
    private fun getSceneId(tNativeInfo: TAdNativeInfo?): String {
        return if (TextUtils.isEmpty(tNativeInfo?.sceneId)) {
            "hi_native"
        } else {
            tNativeInfo?.sceneId ?: "hi_native"
        }
    }


    // ===================== 对外API ================================================================


    /**
     * 判断当前缓存池是否有广告
     */
    fun hasCache(): Boolean {
        return nativeInfoList.isNotEmpty()
    }

    /**
     * 加载与展示需要同一个 tNativeAd
     */
    fun getNativeAd(): TNativeAd? {
        return tNativeAd
    }


    /**
     * 同步获取广告
     */
    fun getAdsSync(): TAdNativeInfo? {
        // 缓存池获取到了，那就直接返回
        val nativeInfo = getNativeInfo()
        if (!isUpperLimit()) {
            loadAd("addCallback() --> 同步获取成功 --> 继续装填缓存池")
        }
        return nativeInfo
    }

    /**
     * 媒体获取广告的API
     * retry
     */
    fun addCallback(callback: WrapperAdListener?, sceneName: String?) {

        // 缓存池获取到了，那就直接返回
        val nativeInfo = getNativeInfo()
        nativeInfo?.let {
            callback?.onNativeInfoReady(it)
            // 原生 -- 新版本缓存池 -- 触发统一收口
            //AdReportManager.trigger(sceneName)
            // 检查一下缓存池是否需要补充,没有达到上限就请求。
            if (!isUpperLimit()) {
                loadAd("addCallback() --> 同步获取成功 --> 继续装填缓存池")
            }
            return
        }

        // 同步没有获取到，那就异步获取。 push --> addFirst
        // 如果已经存在了，那就不再加入了 --> 直接触发
        if (!taskList.contains(callback)) {
            taskList.push(callback)
            AdLogger.logSdkNative("${javaClass.simpleName} --> addCallback() --> 创建了任务 -- sceneName = $sceneName")
        }

        // 原生 -- 新版本缓存池 -- 触发统一收口
        //AdReportManager.trigger(sceneName)
        // 加载广告
        loadAd("addCallback() --> 同步没有获取到 --> 进行异步加载")
    }

    /**
     * 页面销毁了 --> 移除Callback
     *          --> 加载成功之后也会移除任务的
     */
    fun removerCallback(callback: WrapperAdListener?) {
        taskList.remove(callback)
        AdLogger.logSdkNative("${javaClass.simpleName} --> removerCallback() --> 还有 ${taskList.size} 个任务")
    }

    /**
     * 将没有使用过的广告重新添加到缓存池中
     */
    fun addUnusedAdToPool(nativeInfo: TAdNativeInfo?) {
        nativeInfo?.let {
            nativeInfoList.addFirst(it)
        }
    }

    /**
     * 添加到缓存池的队列末尾
     */
    fun addUnusedAdToPoolLast(nativeInfo: TAdNativeInfo?) {
        nativeInfo?.let {
            nativeInfoList.addLast(it)
        }
    }

}