package com.transsion.ad.middle.nativead

import android.os.Parcelable
import android.text.TextUtils
import android.view.View
import android.widget.FrameLayout
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.mediation.ad.TAdNativeView
import com.hisavana.mediation.ad.ViewBinder
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.manager.AdPlansStorageManager
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.scene.SceneOnOff
import com.transsion.ad.strategy.AdContextManager
import com.transsion.ad.util.ViewUtil
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import kotlinx.parcelize.IgnoredOnParcel
import kotlinx.parcelize.Parcelize

/**
 * @author: zhangxinbing
 * @date : 2023/12/13 11:10
 * @description: 原生广告包装盒
 */
@Deprecated("")
@Parcelize
class WrapperNativeManager : WrapperAdListener(), Parcelable {

    /**
     * 场景调用的时候传进来的场景ID
     */
    @IgnoredOnParcel
    private var mSceneId: String? = null

    /*** 展示广告的容器*/
    @IgnoredOnParcel
    private var mAdContainer: FrameLayout? = null

    /*** 非标广告计划对象*/
    @IgnoredOnParcel
    private var mAdPlans: AdPlans? = null

    /**
     * 兜底广告计划
     */
    @IgnoredOnParcel
    private var mAdShowFinalPlan: AdPlans? = null

    /*** HiSavana 广告信息*/
    @IgnoredOnParcel
    private var mNativeInfo: TAdNativeInfo? = null

    /***展示的时候使用的 包断广告计划*/
    @IgnoredOnParcel
    private var mNonAdPlans: AdPlans? = null

    @IgnoredOnParcel
    private var mCallback: WrapperAdListener? = null

    /*** 非标广告展示View*/
    @IgnoredOnParcel
    private var buyOutNativeView: BuyOutNativeView? = null

    /*** HiSavana 广告展示View*/
    @IgnoredOnParcel
    private var mTAdNativeView: TAdNativeView? = null

    @IgnoredOnParcel
    private var ctxMap: Map<String, Any> = mutableMapOf()

    /**
     * 是否开启背景模糊
     */
    @IgnoredOnParcel
    private var enableBgBlur: Boolean? = null

    private fun getClassTag(): String = javaClass.simpleName


    // =========================== 广告加载回调 ======================================================
    // =========================== 广告加载回调 ======================================================
    // =========================== 广告加载回调 ======================================================


    /**
     * HiSavana 广告准备完成
     */
    override fun onNativeInfoReady(nativeInfo: TAdNativeInfo?) {
        super.onNativeInfoReady(nativeInfo)
        val genre = AdContextManager.getRemoteGenre()
        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> onNativeInfoReady() --> HiSavana 广告准备完成 --> isMatchVulgarBrand = ${nativeInfo?.isMatchVulgarBrand == true} --> genre = $genre -- ctxMap = $ctxMap",
            writeToFile = false
        )

        // 判断当前是否需要判断上下文
        if (nativeInfo?.isMatchVulgarBrand == true && AdContextManager.isDangerGenre(ctxMap)) {
            onError(null)
            //nativeInfo.release()
            // 复用
            HiSavanaNativeAdManager.getNativeManager(
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            )?.addUnusedAdToPoolLast(nativeInfo)
            AdLogger.logSdkNativeE("${getClassTag()} --> 当前是品牌广告 -- 当前是限制场景 --> 需要屏蔽 --> 重新添加到缓存池中 --> genre = $genre -- ctxMap = $ctxMap")
            return
        }

        // 设置分配的场景
        nativeInfo?.ext = mSceneId
        mNativeInfo = nativeInfo

        // 通知加载成功
        mCallback?.onLoad()
    }

    override fun onClicked(p0: Int) {
        super.onClicked(p0)
        // 将点击事件回调出去
        mCallback?.onClicked(p0)
    }

    override fun onError(p0: TAdErrorCode?) {
        super.onError(p0)
        // 加载广告失败
        // mCallback?.onError(p0)
        // HiSavana 加载失败了 就继续加载兜底广告
        innerLoadAdShowFinal()
    }


    // ========================= API ===============================================================


    /**
     * 资源回收
     */
    fun destroy() {
        innerDestroy()
    }

    /**
     * 是否是包断广告
     */
    fun isMonopolyAd(): Boolean = mNativeInfo == null

    /**
     * 获取场景地
     */
    fun getSceneId(): String? = mSceneId

    fun getNativeInfo(): TAdNativeInfo? = mNativeInfo

    /**
     * 加载原生广告
     */
    suspend fun loadNativeAd(
        sceneId: String, listener: WrapperAdListener?, ctxMap: Map<String, Any> = emptyMap()
    ) {
        val errorMsg = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(errorMsg).not()) {
            onFailCallback(listener = listener, errorMsg = errorMsg)
            return
        }

        this.ctxMap = ctxMap
        innerLoadAd(sceneId, listener, ctxMap = ctxMap)
    }

    /**
     * 当前广告是否加载完成了 -- 用于判断是否需要展示广告
     */
    fun isReady(): Boolean {
        return mAdPlans != null || mNativeInfo != null
    }

    /**
     * 展示广告
     */
    fun showNativeAd(
        adContainer: FrameLayout?, // 展示广告的容器
        isMute: Boolean = true, // 是否静音
        isShowVolumeIcon: Boolean = true, // 是显示音量图标
        viewBinder: ViewBinder?, // 广告展示的样式
    ) {
        runCatching {
            innerAddViewShowAd(adContainer, isMute, isShowVolumeIcon, viewBinder = viewBinder)
        }.getOrElse {
            AdLogger.logSdkNative("${getClassTag()} --> showNativeAd() --> 广告加载失败 --> it = $it")
        }
    }

    /**
     * 是否开启背景模糊
     */
    fun enableBgBlur(enableBgBlur: Boolean) {
        this.enableBgBlur = enableBgBlur
    }


    // ============================ 👇广告加载 =====================================================
    // ============================ 👇广告加载 =====================================================
    // ============================ 👇广告加载 =====================================================


    /**
     * 加载广告
     */
    private suspend fun innerLoadAd(
        sceneId: String, listener: WrapperAdListener?, ctxMap: Map<String, Any>
    ) {
        AdLogger.logSdkNative(
            "${getClassTag()} --> loadNativeAd() --> 开始加载广告 --> sceneId = $sceneId --> ctxMap = $ctxMap",
            writeToFile = false
        )
        mCallback = listener
        mSceneId = sceneId

        // 加载非标还是HiSavana广告
        mAdPlans = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(sceneId = sceneId, ctxMap = ctxMap)
        }

        // 兜底广告计划
        mAdShowFinalPlan = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(
                sceneId = sceneId, adShowLevel = MbAdShowLevel.MB_AD_SHOW_FINAL, ctxMap = ctxMap
            )
        }

        // 广告触发 统一入口处理
        AdReportProvider.trigger(
            sceneId = sceneId,
            adType = MbAdType.MB_AD_TYPE_NATIVE,
            adSource = if (mAdPlans == null) MbAdSource.MB_AD_SOURCE_HISAVANA_TRIGGER else MbAdSource.MB_AD_SOURCE_MB_TRIGGER,
            planId = mAdPlans?.id
        )

        // 广告展示优先级 --> 非标广告 > HiSavana广告
        if (null == mAdPlans) {
            innerLoadHiSavanaAd(sceneId)
        } else {
            // 加载 非标广告
            if (SceneOnOff.isSceneNonOff(sceneId).not()) {
                innerLoadAdPlan()
            } else {
                innerLoadHiSavanaAd(sceneId)
            }
        }
    }

    /**
     * 加载HiSavana广告
     */
    private fun innerLoadHiSavanaAd(sceneId: String) {
        // 加载 HiSavana 广告
        if (SceneOnOff.isSceneHiOff(sceneId).not()) {
            HiSavanaNativeAdManager.getNativeManager(
                SceneCommonConfig.getHiSavanaPlacementId(mSceneId)
            )?.addCallback(this, mSceneId) ?: run {
                innerLoadAdShowFinal()
            }
        } else {
            innerLoadAdShowFinal()
        }
    }

    /**
     * 加载包断广告
     */
    private fun innerLoadAdPlan() {
        //NonNativeManager().loadAd(this, mAdPlans)
        // 能从数据库取出来，那就一定是可用使用的
        AdLogger.logSdkNative(
            "${getClassTag()} --> innerLoadAdPlan() --> 包断广告可以使用 --> sceneId = $mSceneId",
            writeToFile = false
        )
        onNonNativeReady(mAdPlans)
    }

    /**
     * 加载兜底包断广告
     */
    private fun innerLoadAdShowFinal() {
        if (mAdShowFinalPlan == null) {
            AdLogger.logSdkNative(
                "${getClassTag()} --> innerLoadAdShowFinal() --> 当前没有兜底广告 --> sceneId = $mSceneId",
                writeToFile = false
            )
            mCallback?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_WRAPPER_AD, "没有兜底广告 --> sceneId = $mSceneId"
                )
            )
        } else {
            // 当前有兜底广告可用
            AdLogger.logSdkNative(
                "${getClassTag()} --> innerLoadAdShowFinal() --> 当前有兜底广告可用 --> sceneId = $mSceneId",
                writeToFile = false
            )
            // 能从数据库取出来，那就一定是可用使用的
            onNonNativeReady(mAdShowFinalPlan)
        }
    }

    /**
     * 非标广告准备完成
     */
    private fun onNonNativeReady(adPlan: AdPlans?) {
        mNonAdPlans = adPlan
        // 通知加载成功
        mCallback?.onLoad()
    }


    // =========================== 👇广告展示 =======================================================
    // =========================== 👇广告展示 =======================================================
    // =========================== 👇广告展示 =======================================================


    /**
     * 广告展示
     */
    private fun innerAddViewShowAd(
        adContainer: FrameLayout?,
        isMute: Boolean,
        isShowVolumeIcon: Boolean,
        viewBinder: ViewBinder?, // 广告展示的样式
    ) {

        // 展示广告的容器
        mAdContainer = adContainer

        // mNativeInfo 不为空一位置 HiSavana 广告可以展示
        if (mNativeInfo == null) {
            innerShowNonNativeAd(
                adContainer = adContainer,
                isMute = isMute,
                isShowVolumeIcon = isShowVolumeIcon,
                viewBinder = viewBinder
            )
        } else {
            // 加载与展示需要同一个NativeAd
            innerShowHiSavanaAd(adContainer = adContainer, viewBinder = viewBinder)
        }
    }

    /**
     * 展示包断广告
     */
    private fun innerShowNonNativeAd(
        adContainer: FrameLayout?,
        isMute: Boolean,
        isShowVolumeIcon: Boolean,
        viewBinder: ViewBinder?, // 广告展示的样式
    ) {
        // 创建非标原生广告View
        if (buyOutNativeView == null) {
            buyOutNativeView = BuyOutNativeView(Utils.getApp())
            buyOutNativeView?.enableBgBlur(enableBgBlur = enableBgBlur)
            buyOutNativeView?.setCallback(this)
        } else {
            buyOutNativeView?.removeAllViews()
            ViewUtil.removeSelfFromParent(buyOutNativeView)
        }
        // 绑定数据
        buyOutNativeView?.bindNativeView(
            mSceneId,
            mNonAdPlans,
            viewBinder = viewBinder,
            isMute = isMute,
            isShowVolumeIcon = isShowVolumeIcon
        )

        // 展示广告
        innerAddViewShowAd(buyOutNativeView, adContainer)
    }

    /**
     * 展示HiSavana Native 广告
     */
    private fun innerShowHiSavanaAd(
        adContainer: FrameLayout?,
        viewBinder: ViewBinder?, // 广告展示的样式
    ) {
        HiSavanaNativeAdManager.getNativeManager(
            SceneCommonConfig.getHiSavanaPlacementId(mSceneId)
        )?.getNativeAd()?.let {
            mNativeInfo?.let { info ->
                viewBinder?.let { binder ->
                    // 加载到广告之后 开始组装View 并回调
                    if (null == mTAdNativeView) {
                        mTAdNativeView = TAdNativeView(Utils.getApp())    // 广告View
                    } else {
                        mTAdNativeView?.removeAllViews()
                        ViewUtil.removeSelfFromParent(mTAdNativeView)
                    }

                    mTAdNativeView?.let { tView ->
                        it.bindNativeView(tView, info, binder, it.enterScene(mSceneId, 1))
                        // 修复场景ID为空的情况
                        info.sceneId = if (TextUtils.isEmpty(mSceneId)) {
                            "tag_mSceneId"
                        } else {
                            mSceneId
                        }
                        innerAddViewShowAd(tView, adContainer)
                    }
                }
            } ?: kotlin.run {
                AdLogger.logSdkNative(
                    "${getClassTag()} --> bindNativeView() --> sceneId = $mSceneId 场景接受到回调了 --> null == mNativeInfo"
                )
            }
        }
    }

    /**
     * 数据组装完成之后进行展示
     */
    private fun innerAddViewShowAd(view: View?, adContainer: FrameLayout?) {
        adContainer?.let {
            it.removeAllViews()
            it.visibility = View.VISIBLE
            it.addView(
                view, FrameLayout.LayoutParams(
                    FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.WRAP_CONTENT
                )
            )
        }
    }


    // ========================== 👇资源回收 ========================================================


    /**
     * 资源回收
     */
    private fun innerDestroy() {
        AdLogger.logSdkNative(
            "${getClassTag()} --> destroy() --> sceneId = $mSceneId 场景资源回收了",
            writeToFile = false
        )

        // 移除任务
        HiSavanaNativeAdManager.getNativeManager(
            SceneCommonConfig.getHiSavanaPlacementId(mSceneId)
        )?.removerCallback(this)

        // 是否需要重新添加到缓存池
        mNativeInfo?.let {
            if (TextUtils.isEmpty(mNativeInfo?.ext)) {
                it.release()
            } else {
                HiSavanaNativeAdManager.getNativeManager(
                    SceneCommonConfig.getHiSavanaPlacementId(
                        mSceneId
                    )
                )?.addUnusedAdToPool(it)
            }
        }

        // 资源回收
        buyOutNativeView?.destroy()
        buyOutNativeView = null
        mTAdNativeView?.release()
        mTAdNativeView = null

        mAdContainer?.removeAllViews()
        mAdContainer = null

        // 数据重置
        mCallback = null
        mNativeInfo = null
        mAdShowFinalPlan = null
        mAdPlans = null
        mNonAdPlans = null
    }

    /**
     * 失败回调
     */
    private fun onFailCallback(listener: WrapperAdListener?, errorMsg: String) {
        AdLogger.logSdkSplashE(errorMsg)
        listener?.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_WRAPPER_AD, errorMsg))
    }

}