package com.transsion.ad.middle.nonstandard

import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import com.bumptech.glide.Glide
import com.transsion.ad.AdLogger
import com.transsion.ad.monopoly.intercept.NonAdShowedTimesManager
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.strategy.AdClickManager
import com.transsion.ad.strategy.MeasureManager
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.monopoly.plan.AdPlanUtil

/**
 * @author: zhangxinbing
 * @date : 2024/8/27 16:49
 * @description:
 */
class NonstandardView : FrameLayout, MeasureManager.ViewVisibilityListener {


    /*** 场景调用的时候传进来的场景ID*/
    private var mSceneId: String? = null

    /*** 广告计划信息*/
    private var mAdPlans: AdPlans? = null

    /*** 非标广告素材信息*/
    private var mAdMaterialList: AdMaterialList? = null


    // =============================================================================================


    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context, attrs, defStyleAttr
    )


    // ============================ 曝光检测 =========================================================


    /***广告开始展示的时间 时间戳 毫秒*/
    private var showTime = 0L

    /***是否已经上报过一次曝光了*/
    private var isReportAdDisplay = false

    override fun getVisibilityThreshold(): Double = 10.0

    override fun onVisibilityChanged(isVisible: Boolean) {
        if (isVisible) {
            play()
        } else {
            pause()
        }
    }

    override fun getVisibilityView(): View {
        return this
    }

    private fun pause() {
        // 播放时长上报
        reportShowTime()
    }

    private fun play() {
        // 开始展示的时间
        if (showTime == 0L) {
            showTime = System.currentTimeMillis()
        }

        // 曝光上报
        if (!isReportAdDisplay) {
            isReportAdDisplay = true
            AdReportProvider.display(
                sceneId = mSceneId,
                adPlanId = mAdPlans?.id,
                adSource = MbAdSource.MB_AD_SOURCE_NONSTANDARD,
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_NONSTANDARD,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
                psId = AdPlanUtil.getPsId(mAdPlans)
            )
            AdLogger.logSdkNative(
                "${javaClass.simpleName} --> 广告展示 --> sceneId = $mSceneId --> isAdShowFinal = ${
                    MbAdShowLevel.isAdShowLevel(
                        mAdPlans
                    )
                }", writeToFile = false
            )

            // 保存展示次数
            NonAdShowedTimesManager.saveShowedTimes(mAdPlans)
        }
    }


    // =============================================================================================


    /**
     * 资源回收
     */
    fun destroy() {
        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> destroy() --> sceneId = $mSceneId --> isAdShowFinal = ${
                MbAdShowLevel.isAdShowLevel(
                    mAdPlans
                )
            }", writeToFile = false
        )
        removeAllViews()
        // 添加检测
        MeasureManager.removeSession(this)

        // 资源回收之前需要判断一下是否需要上报一下展示时长埋点
        reportShowTime()
    }

    /**
     * 绑定原生广告
     */
    fun bindNonstandardView(sceneId: String?, adPlans: AdPlans?) {
        mSceneId = sceneId
        // 目前规定一个计划只有一个素材
        mAdMaterialList = adPlans?.adMaterialList?.get(0)
        // 广告计划
        mAdPlans = adPlans

        // 展示广告的View
        val nonIv = ImageView(context)
        nonIv.scaleType = ImageView.ScaleType.FIT_CENTER
        if (TextUtils.isEmpty(mAdMaterialList?.image?.path)) {
            Glide.with(context).load(mAdMaterialList?.image?.url).into(nonIv)
        } else {
            Glide.with(context).load(mAdMaterialList?.image?.path).into(nonIv)
        }

        // 点击事件
        nonIv.setOnClickListener {
            clickAd()
        }

        // 组装View
        addView(
            nonIv, LayoutParams(
                LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT
            )
        )
        // 添加检测
        MeasureManager.addSession(this@NonstandardView)
    }


    // =============================================================================================


    /**
     * 上报累计展示埋点
     */
    private fun reportShowTime() {
        if (showTime > 0) {
            // 上报曝光时长
            AdReportProvider.adShowTime(
                sceneId = mSceneId,
                adPlanId = mAdPlans?.id,
                displayTime = (System.currentTimeMillis() - showTime),
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_NONSTANDARD,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans)
            )
            showTime = 0
        }
    }

    /**
     * 广告点击事件
     */
    private fun clickAd() {
        // 广告点击事件处理
        AdClickManager.adClick(
            deeplink = mAdMaterialList?.deeplink, h5Url = mAdMaterialList?.h5Link, adPlan = mAdPlans
        )

        AdLogger.logSdkNative(
            "${javaClass.simpleName} --> 广告点击了 --> sceneId = $mSceneId --> isAdShowFinal = ${
                MbAdShowLevel.isAdShowLevel(
                    mAdPlans
                )
            }", writeToFile = false
        )
        // 点击埋点曝光
        AdReportProvider.adClick(
            sceneId = mSceneId,
            adPlanId = mAdPlans?.id,
            adSource = MbAdSource.MB_AD_SOURCE_NONSTANDARD,
            adId = mAdMaterialList?.id,
            adType = MbAdType.MB_AD_TYPE_NONSTANDARD,
            isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
            psId = AdPlanUtil.getPsId(mAdPlans)
        )
    }

}