package com.transsion.ad.middle.nonstandard

import android.text.TextUtils
import android.view.View
import android.widget.FrameLayout
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.monopoly.manager.AdPlansStorageManager
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.scene.SceneOnOff
import com.transsion.ad.util.ViewUtil
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author: zhangxinbing
 * @date : 2024/8/27 16:22
 * @description: 非标广告
 */
class WrapperNonstandardManager {

    /*** 非标广告计划对象*/
    private var mAdPlans: AdPlans? = null

    /*** 场景调用的时候传进来的场景ID*/
    private var mSceneId: String? = null
    private var mCallback: WrapperAdListener? = null

    /*** 展示广告的容器*/
    private var mAdContainer: FrameLayout? = null

    private var nonstandardView: NonstandardView? = null

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    /**
     * 加载原生广告
     */
    suspend fun loadNonstandardAd(sceneId: String, listener: WrapperAdListener?) {
        val errorMsg = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(errorMsg).not()) {
            listener?.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_WRAPPER_AD, errorMsg))
            return
        }
        innerLoadAd(sceneId, listener)
    }

    /**
     * 展示广告
     */
    fun showNonstandardAd(adContainer: FrameLayout?) {
        innerAddViewShowAd(adContainer)
    }

    /**
     * 资源回收
     */
    fun destroy() {
        mAdPlans = null
        mSceneId = null
        mCallback = null

        mAdContainer?.removeAllViews()
        mAdContainer = null

        nonstandardView?.destroy()
        nonstandardView = null
    }


    // ============================ 👇广告加载 =====================================================


    /**
     * 加载广告
     */
    private suspend fun innerLoadAd(sceneId: String, listener: WrapperAdListener?) {
        AdLogger.logSdkNative(
            "${getClassTag()} --> innerLoadAd() --> 开始加载广告 --> sceneId = $sceneId",
            writeToFile = false
        )
        mCallback = listener
        mSceneId = sceneId

        // 加载非标还是HiSavana广告
        mAdPlans = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(sceneId, ctxMap = emptyMap())
        }

        // 广告触发 统一入口处理
        AdReportProvider.trigger(
            sceneId = sceneId,
            adType = MbAdType.MB_AD_TYPE_NONSTANDARD,
            adSource = MbAdSource.MB_AD_SOURCE_NONSTANDARD,
            planId = mAdPlans?.id
        )

        // 兜底广告计划
        val mAdShowFinalPlan = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(
                sceneId = sceneId, adShowLevel = MbAdShowLevel.MB_AD_SHOW_FINAL, ctxMap = emptyMap()
            )
        }
        if (mAdPlans == null) {
            mAdPlans = mAdShowFinalPlan
        }

        // 广告展示优先级 --> 非标广告 > HiSavana广告
        if (null != mAdPlans) {
            listener?.onLoad()
        } else {
            listener?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_WRAPPER_AD,
                    "${getClassTag()} --> innerLoadAd() --> 当前没有广告计划资源"
                )
            )
        }
    }


    // =========================== 👇广告展示 =======================================================


    /**
     * 广告展示
     */
    private fun innerAddViewShowAd(adContainer: FrameLayout?) {

        // 展示广告的容器
        mAdContainer = adContainer

        // 创建非标原生广告View
        if (nonstandardView == null) {
            nonstandardView = NonstandardView(Utils.getApp())
        } else {
            nonstandardView?.removeAllViews()
            ViewUtil.removeSelfFromParent(nonstandardView)
        }

        // 绑定数据
        nonstandardView?.bindNonstandardView(mSceneId, mAdPlans)

        // 展示广告
        adContainer?.let {
            it.removeAllViews()
            it.visibility = View.VISIBLE
            it.addView(
                nonstandardView, FrameLayout.LayoutParams(
                    FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT
                )
            )
        }
    }

}