package com.transsion.ad.middle.splash

import android.annotation.SuppressLint
import android.os.Bundle
import android.text.TextUtils
import android.view.Gravity
import android.view.LayoutInflater
import android.view.TextureView
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.lifecycle.lifecycleScope
import com.blankj.utilcode.util.SizeUtils
import com.bumptech.glide.Glide
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.R
import com.transsion.ad.monopoly.intercept.NonAdShowedTimesManager
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.scene.SceneStorage
import com.transsion.ad.strategy.AdClickManager
import com.transsion.ad.strategy.AdTagManager
import com.transsion.ad.strategy.MeasureManager
import com.transsion.ad.util.FastClickUtils
import com.transsion.ad.view.AdTagView
import com.transsion.player.MediaSource
import com.transsion.player.config.VodConfig
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.orplayer.ORPlayer
import com.transsion.player.orplayer.PlayError
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.monopoly.plan.AdPlanUtil
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
 * @author: zhangxinbing
 * @date : 2024/2/20 13:33
 * @description: 开屏广告 -- 目前仅仅展示非标 -- 非标广告 开屏
 */
@Deprecated("BiddingSplashManager")
@SuppressLint("CustomSplashScreen")
class NonSplashActivity : AppCompatActivity(), MeasureManager.ViewVisibilityListener {

    /**
     * 倒计时按钮
     */
    private var tvCountDown: TextView? = null

    /**
     * 控制音频的按钮
     */
    private var mIsShowVolumeIcon: Boolean = true

    /**
     * 是否打开视频的声音
     */
    private var mIsMute: Boolean = true

    /**
     * 视频播放器
     */
    private var mOrPlayer: ORPlayer? = null

    /**
     * 广告计划信息
     */
    private var mAdPlans: AdPlans? = null

    /**
     * 非标广告素材信息
     */
    private var mAdMaterialList: AdMaterialList? = null

    private fun getClassTag(): String = javaClass.simpleName

    companion object {
        const val DEFAULT_COUNT_DOWN_SECONDS = 5

        const val EXT_SCENE_ID = "scene_id"         // 场景ID
        const val EXT_APP_LAYOUT = "app_layout"     // App 信息布局
    }


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_non_splash)

        // 获取广告计划并进行展示
        WrapperSplashManager.getAdPlan()?.let {
            showAdLayout(it)
            showCountDown()

            // 展示App的信息
            showAppInfo()
        } ?: run {
            finish()
        }
    }

    override fun onPause() {
        super.onPause()
        // 播放时长上报
        reportShowTime()
    }

    override fun onDestroy() {
        super.onDestroy()
        // 添加检测
        MeasureManager.removeSession(this)
        WrapperSplashManager.destroy()
        mOrPlayer?.release()
        AdLogger.logSdkSplash("${getClassTag()} --> onDestroy() --> 开屏广告关闭 -- 资源回收")
    }


    // ================================ 广告曝光回调 =================================================


    /***广告开始展示的时间 时间戳 毫秒*/
    private var showTime = 0L

    /***是否已经上报过一次曝光了*/
    private var isReportAdDisplay = false

    override fun onVisibilityChanged(isVisible: Boolean) {
        if (isVisible) {
            // 开始展示的时间
            if (showTime == 0L) {
                showTime = System.currentTimeMillis()
            }

            // 视频状态处理
            if (mOrPlayer?.isPlaying() == false) {
                mOrPlayer?.play()
            }

            // 曝光上报
            if (!isReportAdDisplay) {
                isReportAdDisplay = true
                AdReportProvider.display(
                    sceneId = getSceneId(),
                    adPlanId = mAdPlans?.id,
                    adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
                    adId = mAdMaterialList?.id,
                    adType = MbAdType.MB_AD_TYPE_SPLASH,
                    isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
                    psId = AdPlanUtil.getPsId(mAdPlans)
                )

                AdLogger.logSdkSplash(
                    "${javaClass.simpleName} --> 开屏广告展示 --> isAdShowLevel = ${
                        MbAdShowLevel.isAdShowLevel(
                            mAdPlans
                        )
                    }"
                )
                saveShowCount()
            }

        } else {
            mOrPlayer?.pause()

            // 播放时长上报
            reportShowTime()
        }
    }

    override fun getVisibilityView(): View? {
        return findViewById<FrameLayout>(R.id.container)
    }

    /**
     * 保存当前展示次数
     */
    private fun saveShowCount() {
        NonAdShowedTimesManager.saveShowedTimes(mAdPlans)
//        CoroutineScope(Dispatchers.IO).launch {
//            val nonAdPlans = AdPlansTransform.transformAdPlans2NonAdPlans(mAdPlans)
//            val showedTimes = nonAdPlans.showedTimes ?: 0
//            nonAdPlans.showedTimes = showedTimes + 1
//            nonAdPlans.showDate = AdUtils.getCurrentDate()
//            AppDatabase.getInstance(Utils.getApp()).nonAdPlansDao().update(nonAdPlans)
//        }
    }

    /**
     * 上报累计展示埋点
     */
    private fun reportShowTime() {
        if (showTime > 0) {
            // 上报曝光时长
            AdReportProvider.adShowTime(
                sceneId = getSceneId(),
                adPlanId = mAdPlans?.id,
                displayTime = (System.currentTimeMillis() - showTime),
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_SPLASH,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans)
            )
            showTime = 0
        }
    }


    // ================================= 广告内容展示 ================================================


    private fun showAdLayout(adPlans: AdPlans) {

        mAdPlans = adPlans
        // 目前规定一个计划只有一个素材
        mAdMaterialList = adPlans.adMaterialList?.get(0)

        // 点击事件
        findViewById<FrameLayout>(R.id.container)?.setOnClickListener {
            if (FastClickUtils.isFastClick(it.id, 500)) {
                return@setOnClickListener
            }

            // 点击埋点曝光
            AdReportProvider.adClick(
                sceneId = getSceneId(),
                adPlanId = adPlans.id,
                adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_SPLASH,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
                psId = AdPlanUtil.getPsId(mAdPlans)
            )

            // 广告点击事件处理
            AdClickManager.adClick(
                deeplink = mAdMaterialList?.deeplink,
                h5Url = mAdMaterialList?.h5Link,
                adPlan = mAdPlans
            )

            // 点击 -- 进入落地页 -- 销毁当前
            finish()
        }

        // 广告 Logo 展示
        findViewById<AdTagView>(R.id.adIcon)?.apply {
            AdTagManager.handleForAdTagView(this)
        }

        // 展示媒体内容
        if (mAdMaterialList?.type == AdMaterialList.NON_AD_TYPE_TEXT) {
            showImage()
        } else {
            playVideo()
        }
    }

    /**
     * 展示视频
     */
    private fun playVideo() {
        // 主图 -- 这里需要判断是视频还是图片 -- 测试 先开发图片
        findViewById<FrameLayout>(R.id.container)?.apply {
            removeAllViews()
            // 创建展示视频的View
            val textureView = TextureView(context)
            addView(textureView)

            // 控制音频的按钮
            if (mIsShowVolumeIcon) {
                val imageView = ImageView(this.context)
                setVolumeImage(imageView)
                val layoutParams =
                    FrameLayout.LayoutParams(SizeUtils.dp2px(20f), SizeUtils.dp2px(20f))
                layoutParams.gravity = Gravity.END or Gravity.TOP
                layoutParams.topMargin = SizeUtils.dp2px(10f)
                layoutParams.marginEnd = SizeUtils.dp2px(10f)
                imageView.setOnClickListener {
                    AdLogger.logSdkSplash("${javaClass.simpleName} --> playVideo() --> 点击了音频按钮")
                    // 设置静音
                    mIsMute = mIsMute.not()
                    mOrPlayer?.setMute(mIsMute)
                    setVolumeImage(imageView)
                }
                addView(imageView, layoutParams)
            }

            // 创建播放器
            mOrPlayer = ORPlayer.Builder(context)
                .vodConfig(VodConfig(clearFrameWhenStop = false, openAudioFocus = false)).builder()
                .apply {
                    setMute(mIsMute)
                    setTextureView(textureView)
                    setBackgroundColor(ContextCompat.getColor(context, R.color.ad_bg_01))
                    setLooping(true)
                    setPlayerListener(object : IPlayerListener {

                        override fun onPlayError(
                            errorInfo: PlayError, mediaSource: MediaSource?
                        ) {
                            super.onPlayError(errorInfo, mediaSource)
                            AdLogger.logSdkSplashE("${javaClass.simpleName} --> playVideo() --> onPlayError() --> errorInfo = $errorInfo")
                        }

                        override fun onPrepare(mediaSource: MediaSource?) {
                            super.onPrepare(mediaSource)
                            play()
                        }

                    })
                }
            //mOrPlayer?.setDataSource(DOWNLOAD_FILE_PATH_OLD?.absolutePath + File.separator + "non_ad" + File.separator + "Trailer—The_Perfect_Date.mp4")
            if (TextUtils.isEmpty(mAdMaterialList?.video?.path)) {
                mOrPlayer?.setDataSource(
                    MediaSource(
                        mAdMaterialList?.video?.url ?: "", mAdMaterialList?.video?.url ?: ""
                    )
                )
            } else {
                mOrPlayer?.setDataSource(
                    MediaSource(
                        mAdMaterialList?.video?.path ?: "", mAdMaterialList?.video?.path ?: ""
                    )
                )
            }

            mOrPlayer?.prepare()
        }
    }

    /**
     * 展示图片
     */
    private fun showImage() {
        // 主图 -- 这里需要判断是视频还是图片 -- 测试 先开发图片
        findViewById<FrameLayout>(R.id.container)?.apply {
            removeAllViews()
            val imageView = ImageView(context)
            // 广告SDK也是这么处理的
            imageView.scaleType = ImageView.ScaleType.FIT_CENTER
            // 如果本地地址是空的，那就不使用线上地址在线加载
            if (TextUtils.isEmpty(mAdMaterialList?.image?.path)) {
                Glide.with(context).load(mAdMaterialList?.image?.url).into(imageView)
            } else {
                Glide.with(context).load(mAdMaterialList?.image?.path).into(imageView)
            }
            addView(imageView)
        }
    }

    /**
     * 设置音频按钮的Icon
     */
    private fun setVolumeImage(imageView: ImageView) {
        if (mIsMute) {
            imageView.setImageResource(R.mipmap.ad_volumeoff)
        } else {
            imageView.setImageResource(R.mipmap.ad_volumeon)
        }
    }

    /**
     * 倒计时展示
     */
    @SuppressLint("StringFormatMatches")
    private fun showCountDown() {
        MeasureManager.addSession(this)
        val config = SceneStorage.getSceneConfig(getSceneId())
        val countDownSeconds = config?.get("countDown")?.asInt ?: DEFAULT_COUNT_DOWN_SECONDS
        tvCountDown = findViewById<TextView?>(R.id.tvCountDown).apply {
            visibility = View.VISIBLE
            text = String.format(getString(R.string.skip_ad, countDownSeconds))
            setOnClickListener {
                // 点击skip按钮，跳过广告
                finish()
            }
        }

        lifecycleScope.launch {
            repeat(countDownSeconds) {
                delay(1000)
                tvCountDown?.text = String.format(
                    getString(R.string.skip_ad), countDownSeconds - 1 - it
                )
            }

            // 倒计时结束 关闭当前界面
            finish()
        }
    }

    private fun getSceneId(): String? = intent?.getStringExtra(EXT_SCENE_ID)

    private fun getAppLayout(): Int = intent?.getIntExtra(EXT_APP_LAYOUT, 0) ?: 0

    private fun showAppInfo() {
        kotlin.runCatching {
            findViewById<FrameLayout>(R.id.movieBoxLayout)?.apply {
                removeAllViews()
                val inflate =
                    LayoutInflater.from(this@NonSplashActivity).inflate(getAppLayout(), this, false)
                addView(inflate)
            }
        }
    }
}