package com.transsion.ad.middle.splash

import android.content.Context
import android.content.Intent
import android.text.TextUtils
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.monopoly.manager.AdPlansStorageManager
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.scene.SceneOnOff
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.middle.WrapperAdListener
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author: zhangxinbing
 * @date : 2024/2/20 10:17
 * @description: 开屏广告 目前仅仅展示非标
 * 单例模式
 */
@Deprecated("BiddingSplashManager")
object WrapperSplashManager {

    /**
     * 将获取到的广告计划保存在本地
     */
    private var mAdPlan: AdPlans? = null

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    /**
     * 加载开屏广告 -- 将结果通过 listener 返回
     * listener?.onError()
     * listener?.onLoad()
     */
    suspend fun loadSplashAd(sceneId: String, listener: WrapperAdListener?) {
        listener?.onStart(sceneId)

        // 统一判断
        val errorMsg = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(errorMsg).not()) {
            onFailCallback(listener = listener, errorMsg = errorMsg)
            AdReportProvider.reject(
                sceneId = sceneId,
                adType = MbAdType.MB_AD_TYPE_SPLASH,
                adSource = MbAdSource.MB_AD_SOURCE_MB_TRIGGER,
                rejectMsg = errorMsg
            )
            return
        }

        // 因为开屏广告仅有包断，所以仅需要判断 SceneOnOff.isSceneNonOff(sceneId).not()
        if (SceneOnOff.isSceneNonOff(sceneId)) {
            onFailCallback(
                listener = listener, errorMsg = "非标广告场景关闭 --> sceneId = $sceneId"
            )
            return
        }

        // 加载广告
        innerLoadSplashAd(sceneId, listener)
    }

    /**
     * 展示广告 -- 接收到加载成功的回调之后调用
     */
    fun showSplash(sceneId: String, appLayout: Int, context: Context?) {
        if (null != getAdPlan()) {
            context?.let {
                val intent = Intent(it, NonSplashActivity::class.java)
                intent.putExtra(NonSplashActivity.EXT_SCENE_ID, sceneId)
                intent.putExtra(NonSplashActivity.EXT_APP_LAYOUT, appLayout)
                it.startActivity(intent)
            }
        } else {
            // 理论上来说这里是不会调用的，不排除API调用错误在展示之前调用了 destroy()
            AdLogger.logSdkSplashE("${getClassTag()} --> showSplash() --> getAdPlan() == null")
        }
    }

    fun getAdPlan(): AdPlans? = mAdPlan

    fun destroy() {
        mAdPlan = null
    }


    // =============================================================================================


    /**
     * 失败回调
     */
    private fun onFailCallback(listener: WrapperAdListener?, errorMsg: String) {
        AdLogger.logSdkSplashE(errorMsg)
        listener?.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_WRAPPER_AD, errorMsg))
    }

    /**
     * 加载非标开屏广告 通过 listener 返回结果
     */
    private suspend fun innerLoadSplashAd(sceneId: String, listener: WrapperAdListener?) {

        // 获取非标广告的广告计划
        var mAdPlans = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(sceneId = sceneId, ctxMap = emptyMap())
        }

        // 目前开屏仅有包断广告
        // 广告触发 统一入口处理
        AdReportProvider.trigger(
            sceneId = sceneId,
            adType = MbAdType.MB_AD_TYPE_SPLASH,
            adSource = MbAdSource.MB_AD_SOURCE_MB_TRIGGER,
            planId = mAdPlans?.id
        )

        if (null == mAdPlans) {
            // 兜底广告计划
            mAdPlans = withContext(Dispatchers.IO) {
                AdPlansStorageManager.getAdPlans(
                    sceneId, adShowLevel = MbAdShowLevel.MB_AD_SHOW_FINAL, ctxMap = emptyMap()
                )
            }
        }

        // TODO 因为有延迟初始化 --> 仅能加载包断广告
        // 广告展示优先级 --> 非标广告 > HiSavana广告
        if (null == mAdPlans) {
            onFailCallback(
                listener = listener,
                errorMsg = "${getClassTag()} --> innerLoadSplashAd() --> 没有广告计划资源 --> sceneId = $sceneId"
            )
        } else {
            mAdPlan = mAdPlans
            listener?.onLoad()
        }
    }
}