package com.transsion.ad.monopoly

import com.transsion.ad.monopoly.manager.AdPlansAssetsManager
import com.transsion.ad.monopoly.manager.AdPlansRequestManager
import com.transsion.ad.monopoly.manager.AdSceneAssetsManager
import com.transsion.ad.ps.attribution.AttributionConsumeManager

/**
 * @author: zhangxinbing
 * @date : 2025/2/14 16:24
 * @description: 包断广告初始化
 */
object MonopolyAdManager {

    /**
     * 初始化 -- 子线程调用
     */
    suspend fun init(adConfigUrl: String, callback: ((result: Boolean) -> Unit)? = null) {
        // 将资源文件保存到下载目录中
        AdPlansAssetsManager.saveAssets2Download()

        // 内置场景
        AdSceneAssetsManager.saveAssetsFile()

        // 归因数据触发
        AttributionConsumeManager.consume()

        // 检查数据库里面的广告计划是不是资源都下载了
        AdPlansRequestManager.requestNonAdPlanList(adConfigUrl, callback)
    }

}