package com.transsion.ad.monopoly.intercept

import com.transsion.ad.AdLogger
import com.transsion.ad.MbAdContents
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.plan.AdPlanSourceManager
import com.transsion.ad.util.FileUtil
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlansHitResponse
import com.transsion.ad.monopoly.plan.AdPlansTransform
import com.transsion.ad.strategy.AdMmkv

/**
 * @author: zhangxinbing
 * @date : 2024/3/18 21:00
 * @description: 当前广告计划资源是否下载完成
 */
internal class AdResourceDownloadedHandler : AbsAdPlanInterceptHandler() {

    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {
        // 资源是否已经下载完成了
        var hasResource = false

        // Hi程序化需要实时请求SDK获取素材
        // 前置判断如果是Hi程序化广告计划默认返回true
        if (AdPlanSourceManager.isHiAdPlan(plans)) {
            return getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        }

        // 前置判断如果是PS虚拟计划广告计划默认返回true
        if (AdPlanSourceManager.isPsAdPlan(plans)) {
            return getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        }

        // 获取计划
        val adPlans = AdPlansTransform.transformPlanDb2Bean(plans)

        // 判断素材文件是否存在
        adPlans?.adMaterialList?.forEach {
            hasResource = if (it.type == AdMaterialList.NON_AD_TYPE_TEXT) {
                FileUtil.isFileExists(it.image?.path ?: "")
            } else {
                FileUtil.isFileExists(it.video?.path ?: "")
            }
        }

        // 日志输出
        if (hasResource.not()) {
            // 用户可能手动将文件删除了，这个时候需要重新请求。
            if (AdPlanSourceManager.isDefaultAdPlan(plans)) {
                AdMmkv.mmkvWithID.putString(MbAdContents.NON_AD_PLAN_VERSION, "")
                AdLogger.logAdInitE("${getClassTag()} --> hasResource() --> 用户可能手动将文件删除了，这个时候需要重新请求。 --> 包断广告版本号 重置")
            }

            // 如果计划对应的PS商单没有数据，那就需要重新请求PS接口
            //if (AdPlanSourceManager.isPsAdPlan(plans)) {
            //PsAdPlanRetryManager.retry(plans)
            //}
        }

        // 当前条件通过继续下一个条件判断 -- 否则直接返回失败
        return if (hasResource) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "广告资源未下载完成")
        }
    }
}