package com.transsion.ad.monopoly.intercept

import android.text.TextUtils
import com.blankj.utilcode.util.GsonUtils
import com.tn.lib.net.cons.HeaderConst
import com.tn.lib.net.utils.MkvHeader
import com.tn.lib.util.device.TNDeviceHelper
import com.transsion.ad.AdLogger
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse

/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:45
 * @description: 手机品牌黑名单判断 -- 设备品牌 是否在黑名单中 如果null都展示
 */
internal class InDenyBrandHandler : AbsAdPlanInterceptHandler() {
    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        // 当前设备是否在黑名单中
        var isInDenyBrand = false

        // 数据解析
        var currentBrand = ""
        val denyBrand = plans?.denyBrand
        val denyBrandFromJson = GsonUtils.fromJson(denyBrand, Array<String>::class.java)
        if (denyBrandFromJson.isNullOrEmpty()) {
            isInDenyBrand = false
        } else {
            // 获取当前手机品牌获取
            var brand = MkvHeader.netMmkv?.getString(HeaderConst.PHONE_BRAND, "") ?: ""
            if (TextUtils.isEmpty(brand)) {
                brand = TNDeviceHelper.getBrand()
            }
            currentBrand = brand

            denyBrandFromJson.forEach {
                // 这里匹配规则需要包含
                if (it.lowercase().contains(currentBrand.lowercase()) || currentBrand.lowercase()
                        .contains(it.lowercase())
                ) {
                    isInDenyBrand = true
                }
            }
        }

        // 当前条件通过继续下一个条件判断 -- 否则直接返回失败
        return if (isInDenyBrand.not()) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "当前手机品牌在黑名单中")
        }
    }
}