package com.transsion.ad.monopoly.intercept

import com.blankj.utilcode.util.GsonUtils
import com.tn.lib.util.device.TNDeviceHelper
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse

/**
 * @author: zhangxinbing
 * @date : 2024/3/20 10:54
 * @description: 手机机型白名单判断
 */
internal class ModelInWhitelistHandler : AbsAdPlanInterceptHandler() {

    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {
        // 机型黑名单判断
        val planModel = plans?.model
        val modelFromJson = GsonUtils.fromJson(planModel, Array<String>::class.java)
        if (modelFromJson.isNullOrEmpty()) {
            // 白名单为空，返回匹配成功。
            return getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        }

        val currentModel = TNDeviceHelper.getModel()
        var denyModel = false
        modelFromJson.forEach {
            // 这里匹配规则需要包含
            if (it.lowercase().contains(currentModel.lowercase()) || currentModel.lowercase()
                    .contains(it.lowercase())
            ) {
                denyModel = true
            }
        }

        // 白名单不为空 且不在白名单中 返回没有匹配
        return if (denyModel) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "当前手机机型不在白名单中")
        }
    }
}