package com.transsion.ad.monopoly.intercept

import android.text.TextUtils
import com.blankj.utilcode.util.GsonUtils
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse

/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:30
 * @description: 当前场景是否在白名单中
 */
internal class SceneInWhitelistHandler : AbsAdPlanInterceptHandler() {
    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        var isSceneInWhitelist = false
        val planScenes = plans?.scenes
        val scenesFromJson = GsonUtils.fromJson(planScenes, Array<String>::class.java)

        // 没有配置表示全部场景都可以展示
        if (scenesFromJson.isNullOrEmpty()) {
            isSceneInWhitelist = true
        } else {
            scenesFromJson.forEach {
                // 这里直接完全匹配，因为场景id是唯一的
                if (TextUtils.equals(it.lowercase(), sceneId.lowercase())) {
                    isSceneInWhitelist = true
                }
            }
        }

        // 当前条件通过继续下一个条件判断 -- 否则直接返回失败
        return if (isSceneInWhitelist) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "当前场景不在白名单中")
        }
    }
}
