package com.transsion.ad.monopoly.intercept

import com.tn.lib.util.networkinfo.NetworkUtil
import com.transsion.ad.AdLogger
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse
import org.json.JSONObject

/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:24
 * @description:
 */
internal class ShowOnNetworkStateHandler : AbsAdPlanInterceptHandler() {

    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        // on 表示只在网络环境下展示, off 表示只无网环境下展示 null 表示有网无网都展示
        val isShowOnNetwork = isShowOnNetwork(plans)
        val networkStatus = NetworkUtil.hasCapabilityAsync()
        val isShow = if (networkStatus) { // 有网
            isShowOnNetwork == null || isShowOnNetwork == true
        } else { // 无网
            isShowOnNetwork == null || isShowOnNetwork == false
        }

        // 当前条件通过继续下一个条件判断 -- 否则直接返回失败
        return if (isShow) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(
                isHit = false,
                rejectMsg = "当前网络状态 = $networkStatus -- isShowOnNetwork = $isShowOnNetwork"
            )
        }
    }

    private fun isShowOnNetwork(plans: MbAdDbPlans?): Boolean? {
        plans?.extraConfig?.let {
            try {
                JSONObject(it).getString("network").let { network ->
                    return network.lowercase() == "on"  // on 表示只在网络环境下展示, off 表示只无网环境下展示 null 表示有网无网都展示
                }
            } catch (e: Exception) {
                return null
            }
        }
        return null
    }

}