package com.transsion.ad.monopoly.intercept

import com.transsion.ad.AdLogger
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse
import com.transsion.ad.util.TimeUtil


/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:54
 * @description: 当前广告计划的开始时间和结束时间判断
 */
internal class ValidTimeHandler : AbsAdPlanInterceptHandler() {

    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        // 获取当前时间戳
        val currentTimestamp = TimeUtil.getCurrentTimestamp()
        val startTime = plans?.startTime?.toLong() ?: 0L
        val endTime = plans?.endTime?.toLong() ?: 0L

        val isValidTime = currentTimestamp in startTime..endTime

        // 不在展示时间内,那就是拦截
        // 当前条件通过继续下一个条件判断 -- 否则直接返回失败
        return if (isValidTime) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "当前不在展示时间内--有效期")
        }

    }
}