package com.transsion.ad.monopoly.manager

import android.text.TextUtils
import com.transsion.ad.AdLogger
import com.transsion.ad.scene.SceneStorage
import com.transsion.ad.util.AssetsUtil
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author shmizhangxinbing
 * @date : 2025/6/12 19:57
 * @description: 内置场景
 */
object AdSceneAssetsManager {

    private fun getClassTag(): String = javaClass.simpleName

    /**
     * 将资源文件保存到下载目录中
     */
    suspend fun saveAssetsFile() {
        withContext(Dispatchers.IO) {
            kotlin.runCatching {
                if (SceneStorage.hasData()) {
                    AdLogger.logAdInit("${getClassTag()} --> saveAssetsFile() --> 数据已经存在")
                    return@withContext
                }

                // 读取assets文件夹下的配置文件
                val readAssets = AssetsUtil.readAssets("assets_scene.json")
                // 非空判断
                if (TextUtils.isEmpty(readAssets).not()) {
                    AdLogger.logAdInit("${getClassTag()} --> saveAssetsFile() --> readAssets = $readAssets")
                    SceneStorage.setScene4Assets(readAssets)
                } else {
                    AdLogger.logAdInitE("${getClassTag()} --> saveAssetsFile() --> assets数据 -- 保存数据库失败 -- fail fail fail -- readAssets = null")
                }
            }.getOrElse {
                AdLogger.logAdInitE("${getClassTag()} --> saveAssetsFile() --> 保存本地数据异常 -- error error error --> it = $it")
            }
        }
    }

}