package com.transsion.ad.monopoly.model

import androidx.annotation.IntDef

/**
 * @author: zhangxinbing
 * @date : 2024/5/22 14:10
 * @description: 广告类型
 */
@IntDef(
    MbAdType.MB_AD_TYPE_BANNER,
    MbAdType.MB_AD_TYPE_NATIVE,
    MbAdType.MB_AD_TYPE_VIDEO,
    MbAdType.MB_AD_TYPE_INTERSTITIAL,
    MbAdType.MB_AD_TYPE_SPLASH,
    MbAdType.MB_AD_TYPE_ICON,
    MbAdType.MB_AD_TYPE_NONSTANDARD,
)
@Retention(AnnotationRetention.SOURCE)
annotation class MbAdType {
    companion object {
        const val MB_AD_TYPE_BANNER = 1        // banner
        const val MB_AD_TYPE_NATIVE = 2        // native
        const val MB_AD_TYPE_VIDEO = 3         // 激励视频
        const val MB_AD_TYPE_INTERSTITIAL = 4  // 插屏
        const val MB_AD_TYPE_SPLASH = 5        // 开屏
        const val MB_AD_TYPE_ICON = 6          // icon
        const val MB_AD_TYPE_NONSTANDARD = 7   // 非标广告
    }
}