package com.transsion.ad.monopoly.plan

import com.blankj.utilcode.util.Utils
import com.transsion.ad.db.MbAdDatabase
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.ps.PSAdPlanRequestManager
import com.transsion.ad.util.FileUtil
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author: zhangxinbing
 * @date : 2025/5/22 19:15
 * @description: 计划素材管理
 */
object AdPlanMaterialManager {

    /**
     * PS Offer 数据库查询
     */
    private val psLinkAdPlanDao by lazy {
        MbAdDatabase.getInstance(Utils.getApp()).psLinkAdPlanDao()
    }

    suspend fun hasRes(plan: MbAdDbPlans?): Boolean {
        // 资源是否已经下载完成了
        var hasResource = false
        // 查询当前虚拟计划是否有Offer
        val adPlans = AdPlansTransform.transformPlanDb2Bean(plan)
        // 判断素材文件是否存在
        adPlans?.adMaterialList?.forEach {
            hasResource = if (it.type == AdMaterialList.NON_AD_TYPE_TEXT) {
                FileUtil.isFileExists(it.image?.path ?: "")
            } else {
                FileUtil.isFileExists(it.video?.path ?: "")
            }
        }
        return hasResource
    }

    /**
     * 判断当前PS虚拟计划是否有 Offer
     */
    suspend fun hasPsOffer(plan: MbAdDbPlans?): Boolean {
        // 资源是否已经下载完成了
        var hasResource = false
        withContext(Dispatchers.IO) {
            runCatching {
                val adSlot = plan?.extAdSlot ?: PSAdPlanRequestManager.SCENE_CON // PS 广告位ID
                val totalRecords =
                    psLinkAdPlanDao.getCountByExtAdSlot(adSlot.toString()) // 获取数据库中所有记录的数量
                hasResource = totalRecords > 0
            }
        }
        return hasResource
    }

}