package com.transsion.ad.monopoly.plan

import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans

/**
 * @author: zhangxinbing
 * @date : 2025/5/21 19:30
 * @description: 获取广告计划
 */
object AdPlanUtil {

    /**
     * 获取PS直投ID
     */
    fun getPsId(plan: AdPlans?): Long? {
        return kotlin.runCatching {
            if (AdPlanSourceManager.isPsAdPlan(plan)) {
                val adMaterialList = plan?.adMaterialList
                if (adMaterialList.isNullOrEmpty()) {
                    null
                } else {
                    adMaterialList[0].psRecommendInfo?.id
                }
            } else {
                null
            }
        }.getOrElse {
            null
        }
    }

    /**
     * 获取PS包名
     */
    fun getPsPackageName(plan: AdPlans?): String? {
        return kotlin.runCatching {
            if (AdPlanSourceManager.isPsAdPlan(plan)) {
                val adMaterialList = plan?.adMaterialList
                if (adMaterialList.isNullOrEmpty()) {
                    null
                } else {
                    adMaterialList[0].psRecommendInfo?.packageName
                }
            } else {
                null
            }
        }.getOrElse {
            null
        }
    }

    fun getAdMaterial(plan: AdPlans?): AdMaterialList? {
        return if (plan?.adMaterialList?.isNotEmpty() == true) {
            plan.adMaterialList?.get(0)
        } else {
            null
        }
    }

    /**
     * 获取最高价
     */
    fun getHighestEcpmAdPlan(adPlansList: List<AdPlans>?): AdPlans? {
        // 如果集合为空或传入null，直接返回null
        if (adPlansList.isNullOrEmpty()) return null

        // 根据ecpmCent降序排列，ecpm相同则对比sort字段（升序）
        return adPlansList.maxWithOrNull(compareByDescending<AdPlans> { it.ecpmCent }.thenBy { it.sort })
    }


}