package com.transsion.ad.ps

import android.os.SystemClock
import android.text.TextUtils
import com.transsion.ad.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.ps.PSAdPlanRequestManager.SCENE_CON
import com.transsion.ad.scene.SceneGlobalConfig
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

/**
 * @author: zhangxinbing
 * @date : 2025/5/21 21:13
 * @description: 如果没有PS Offer 那就重新请求接口
 */
object PsAdPlanRetryManager {

    private fun getClassTag(): String = javaClass.simpleName

    private var lastTime = 0L


    // =============================================================================================


    fun retry(plan: AdPlans?) {
        // 间隔时间 通过配置下发
        if ((SystemClock.elapsedRealtime() - lastTime < SceneGlobalConfig.getPsLinkInterval())) {
            return
        }
        lastTime = SystemClock.elapsedRealtime()

        AdLogger.logAdInitE("${getClassTag()} --> retry() --> PS 直投的虚拟计划 --> 无商单重试 --> 请求PS商单接口")
        CoroutineScope(Dispatchers.IO).launch {
            var psScene = SCENE_CON
            if (!TextUtils.isEmpty(plan?.extAdSlot)) {
                psScene = plan?.extAdSlot?.toInt() ?: SCENE_CON
            }
            PSAdPlanRequestManager.getPsLinkListBySlot(
                0, false, 10, psScene = psScene, nonId = plan?.id ?: ""
            )
        }
    }

}