package com.transsion.ad.ps

import android.os.Build
import android.text.TextUtils
import com.blankj.utilcode.util.AppUtils
import com.tn.lib.net.cons.HeaderConst
import com.tn.lib.net.interceptor.BaseUrlInterceptor
import com.tn.lib.net.utils.MkvHeader
import com.tn.lib.util.device.TNDeviceHelper
import com.tn.lib.util.md5.MD5
import com.tn.lib.util.networkinfo.NetworkUtil
import com.transsion.ad.ps.model.PsLinkDto
import okhttp3.RequestBody
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.Headers
import retrofit2.http.POST

/**
 * @author xinbing.zhang
 * @date :2023/11/30 20:22
 * @description:
 */
interface PsLinkApi {

    companion object {
        /**
         * 通用参数
         */
        fun commonParams(timestamp: Long): MutableMap<String, Any?> {
            val parameter = mutableMapOf<String, Any?>()
            val channel = "Transsion"
            val sign = MD5.MD5Encode(channel + timestamp)
            parameter["curClientVersionCode"] = PsLinkUtils.getPSVersionCode()
            parameter["channel"] = channel
            parameter["brand"] = Build.BRAND
            parameter["timestamp"] = timestamp
            parameter["sign"] = sign
            parameter["gaid"] = TNDeviceHelper.getGaid()
            parameter["systemVersionCode"] = Build.VERSION.SDK_INT
            parameter["netType"] = NetworkUtil.getNetworkType()
            // 测试环境必须传en 才有数据返回
//            if (BuildConfig.DEBUG) {
//                parameter["lan"] = "en"
//            } else {
//                parameter["lan"] = TNDeviceHelper.getLanguage()
//            }
            parameter["lan"] = TNDeviceHelper.getLanguage()

            var spCode = MkvHeader.netMmkv?.getString(HeaderConst.CUSTOM_LOCAL_ISO, "")?.uppercase()
            if (TextUtils.isEmpty(spCode)) {
                spCode = TNDeviceHelper.getCountryCode()?.uppercase()//TNDeviceHelper.getCountry()
            }
            parameter["countyrCode"] = spCode ?: ""
//            parameter["countryCode"] = "NG" ?: ""
            parameter["ua"] = Build.MODEL
            parameter["curVersionName"] = AppUtils.getAppVersionName()
            parameter["cpu"] = TNDeviceHelper.getCPU()
            parameter["android_version"] = TNDeviceHelper.getOsVersion()
            parameter["imei"] = ""
            parameter["imsi"] = ""
            parameter["sessionID"] = ""
            parameter["lastPage"] = ""
            parameter["curPage"] = ""
            parameter["shareChannel"] = ""
            parameter["platform"] = ""
            return parameter
        }
    }

    /**
     * 请求PS推荐列表
     */
    @Headers("${BaseUrlInterceptor.MULTIPLE_BASE_URL_TAG}:https://feature-api.palmplaystore.com")
    @POST("/distribute/recommend/moviebox")
    suspend fun postPsRecommendList(@Body request: RequestBody?): PsLinkDto

    /**
     * 获取PS商单，如果发现PS商单为空，则可以请求Ps推荐列表用来兜底
     */
    //@Headers("${BaseUrlInterceptor.MULTIPLE_BASE_URL_TAG}:https://test-feature-api.palmplaystore.com")
    @POST("/distribute/candidate")
    suspend fun postPsCandidateList(
        @Body request: RequestBody?, @Header(BaseUrlInterceptor.MULTIPLE_BASE_URL_TAG) url: String
    ): PsLinkDto?
}