package com.transsion.ad.ps

import com.blankj.utilcode.util.GsonUtils
import com.blankj.utilcode.util.Utils
import com.transsion.ad.AdLogger
import com.transsion.ad.db.MbAdDatabase
import com.transsion.ad.db.pslink.PsLinkAdPlan
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdImage
import com.transsion.ad.ps.model.PSAdTypeEnum
import com.transsion.ad.ps.model.PsLinkAdInfo
import com.transsion.ad.ps.model.RecommendInfo
import com.transsion.ad.util.AppUtil

/**
 * @author shmizhangxinbing
 * @date : 2025/7/11 14:09
 * @description: PS  Offer 提供
 */
object PsOfferProvider {

    private val psLinkAdPlanDao by lazy {
        MbAdDatabase.getInstance(Utils.getApp()).psLinkAdPlanDao()
    }

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    /**
     * 处理素材
     */
    suspend fun parsePsAdPlansMaterialList(adPlans: AdPlans?): Boolean {
        // 获取可用的PS Offer
        val availableAdPlan = getAvailableAdPlan(adPlans) ?: return false
        // 赋值 -- 无论PS是否有数据都得赋值
        val materialList = AdMaterialList()
        adPlans?.adMaterialList = listOf(materialList) // 素材信息
        // 获取到数据了
        assignment(adPlans, materialList, availableAdPlan)
        return true
    }


    // =============================================================================================


    /**
     * 获取一个可用的 PS Plan
     */
    private suspend fun getAvailableAdPlan(adPlans: AdPlans?): PsLinkAdPlan? {
        val adSlot = adPlans?.extAdSlot ?: PSAdPlanRequestManager.SCENE_CON // PS 广告位ID
        var totalRecords = psLinkAdPlanDao.getCountByExtAdSlot(adSlot.toString()) // 获取数据库中所有记录的数量
        if (totalRecords == 0) {
            PsAdPlanRetryManager.retry(adPlans)
            return null // 如果没有记录，直接返回 null
        }

        val maxAttempts = 100 // 设定一个合理的最大尝试次数
        var processedCount = 0 // 处理计数器

        // 测试使用
        //val pslinkListAdBySlot = psLinkAdPlanDao.getPslinkListAdBySlot(adSlot.toString())
        //AdLogger.logPS("${getClassTag()} --> getAvailableAdPlan() --> 开始获取可用Offer --> totalRecords = $totalRecords")

        while (processedCount < totalRecords) {
            // 获取 updateTimestamp 最小的对象
            // 如果没有对象（不应该出现这种情况，因为我们已经检查过 totalRecords），退出
            val psAdPlan = psLinkAdPlanDao.getPsLinkAdBySlotWithMinTimestamp(adSlot.toString())
                ?: return null // 没有获取到直接返回

            // 数据转换
            val psRecommendInfo =
                GsonUtils.fromJson(psAdPlan.psInfoJson, RecommendInfo::class.java) ?: return null
            AdLogger.logPS("${getClassTag()} --> getAvailableAdPlan() --> 开始获取可用Offer --> processedCount = $processedCount --> totalRecords = $totalRecords --> updateTimestamp = ${psAdPlan.updateTimestamp}")

            // TODO 测试代码
//            psAdPlan.updateTimestamp = System.currentTimeMillis()
//            psLinkAdPlanDao.updatePsLinkAdPlan(psAdPlan)
//            AdLogger.logPS("${getClassTag()} --> getAvailableAdPlan() --> 返回可用Offer 000 --> name = ${psRecommendInfo.packageName} --> id = ${psRecommendInfo.id} --> updateTimestamp = ${psAdPlan.updateTimestamp} --> adType = ${psRecommendInfo.getAdTypeTxt()}")
//            return psAdPlan // 返回可用Offer

            // 如果当前Offer是拉活单子，那就需要判断是否已经安装，否则展示下一个Offer
            when (psRecommendInfo.adType) {
                PSAdTypeEnum.PS_AD_TYPE_USER_ACQUISITION_0.value -> { // 拉新
                    psAdPlan.updateTimestamp = System.currentTimeMillis()
                    psLinkAdPlanDao.updatePsLinkAdPlan(psAdPlan)
                    AdLogger.logPS("${getClassTag()} --> getAvailableAdPlan() --> 返回可用Offer 000 --> name = ${psRecommendInfo.packageName} --> id = ${psRecommendInfo.id} --> updateTimestamp = ${psAdPlan.updateTimestamp} --> adType = ${psRecommendInfo.getAdTypeTxt()}")
                    return psAdPlan // 返回可用Offer
                }

                PSAdTypeEnum.PS_AD_TYPE_USER_RETENTION_1.value -> { // 拉活
                    // 检查当前应用是否已安装
                    val isInstalled = AppUtil.isAppInstalled(
                        context = Utils.getApp(), packageName = psRecommendInfo.packageName
                    )
                    if (isInstalled) {
                        // 如果已安装，返回当前对象
                        AdLogger.logPS("${getClassTag()} --> getAvailableAdPlan() --> 返回可用Offer 111 --> name = ${psRecommendInfo.packageName} --> id = ${psRecommendInfo.id} --> updateTimestamp = ${psAdPlan.updateTimestamp} --> adType = ${psRecommendInfo.getAdTypeTxt()}")
                        // 如果未安装，更新当前对象的时间戳
                        psAdPlan.updateTimestamp = System.currentTimeMillis()
                        psLinkAdPlanDao.updatePsLinkAdPlan(psAdPlan)
                        return psAdPlan
                    } else {
                        // 如果未安装，更新当前对象的时间戳
                        psAdPlan.updateTimestamp = System.currentTimeMillis()
                        psLinkAdPlanDao.updatePsLinkAdPlan(psAdPlan)
                        AdLogger.logPS("${getClassTag()} --> getAvailableAdPlan() --> 当前Offer 不可用，继续查询下一个可用的Offer 111 --> name = ${psRecommendInfo.packageName} --> id = ${psRecommendInfo.id} --> updateTimestamp = ${psAdPlan.updateTimestamp} --> adType = ${psRecommendInfo.getAdTypeTxt()}")
                    }
                }

                else -> { // 未知类型，不处理
                    return null
                }
            }

            processedCount++ // 增加已处理计数
            totalRecords =
                psLinkAdPlanDao.getCountByExtAdSlot(adSlot.toString()) // 这一步是为了处理在查询的过程中有新增数据

            // 异常兜底
            if (processedCount > maxAttempts) {
                AdLogger.logPSE("${getClassTag()} --> getAvailableAdPlan() --> 赶紧找开发，出现死循环了、赶紧找开发，出现死循环了、赶紧找开发，出现死循环了")
                return null
            }
        }

        // 所有记录都判断过了，无可用对象，返回 null
        return null
    }

    /**
     * 将PS信息赋值到广告计划
     */
    private fun assignment(
        adPlans: AdPlans?, materialList: AdMaterialList, psAdPlan: PsLinkAdPlan?
    ) {
        if (psAdPlan != null) {
            val psAdInfo = GsonUtils.fromJson(psAdPlan.psLinkAdInfoStr, PsLinkAdInfo::class.java)
            val psRecommendInfo = GsonUtils.fromJson(psAdPlan.psInfoJson, RecommendInfo::class.java)

            // 素材信息
            materialList.downloadMaterialSuccess = true // PS计划 默认有资源的
            materialList.type = AdMaterialList.NON_AD_TYPE_TEXT
            materialList.title = psAdInfo?.title
            materialList.desc = psAdInfo?.desc
            materialList.psRecommendInfo = psRecommendInfo
            //todo 宽高信息
            materialList.image = MbAdImage(url = psAdInfo?.url, path = psAdInfo.path)

            // 按钮文案
            materialList.buttonText = psAdInfo?.buttonText

            // 广告主头像
            adPlans?.apply {
                advertiserName = psAdInfo?.advertiserName
                advertiserAvatar = psAdInfo?.advertiserAvatar
                advertiserAvatarPath = psAdInfo?.advertiserAvatarPath
            }

            // 封面图
            // 如果是PS广告计划，产品确认使用广告主头像
            adPlans?.extImage = MbAdImage(
                url = adPlans?.advertiserAvatar, path = adPlans?.advertiserAvatarPath
            )
            //AdLogger.logSdk("${getClassTag()} --> parsePsAdPlansMaterialList() --> 数据库转业务对象 222 --> adPlans 转取完毕 = $adPlans")
        }
    }

}