package com.transsion.ad.report

import com.transsion.ad.MbAdContents
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author: zhangxinbing
 * @date : 2023/12/12 13:55
 * @description:
 */
object AdReportProvider {

    private const val AD_STATE_TYPE_TRIGGER = "trigger" // 触发
    private const val AD_STATE_TYPE_DISPLAY = "display" // 展示
    private const val AD_STATE_TYPE_CLICK = "click" // 点击
    private const val AD_STATE_TYPE_SHOW_TIME = "show_time" // 展示时间

    /**
     * int SSP = 0;
    int ADMOB = 1;
    int FAN = 2;
    /**
     * 1.4.0 新增的广告源
    */
    int APPLOVIN = 3;

    int UNITY = 4;

    /**
     * 新增广告源 141 2022-5-25
    */
    int IRON_SOURCE = 5;

    /****2022-07-05 inmobi*/
    int INMOBI = 8;
    /**
     * 143新增广告源
    */
    int VUNGLE = 12;
    int ADCOLONY = 11;
    //2.0.3.0新增广告源
    int PANGLE = 6;
    //2.1.1.0新增广告源
    int MINTEGRAL = 9;
     */
    private const val AD_MAP_AD_SOURCE = "adSource"
    private const val AD_MAP_ACTION = "action"
    private const val AD_MAP_AD_TYPE = "adType"

    private const val AD_MAP_AD_ID = "ad_id"
    private const val AD_MAP_PLAN_ID = "plan_id"
    private const val AD_MAP_AD_PLAN_ID = "ad_plan_id"
    private const val AD_MAP_SCENE_ID = "scene_id"
    private const val AD_MAP_TRIGGER_ID = "trigger_id"

    //private const val AD_MAP_SOURCE = "ad_source"
    private const val AD_MAP_IS_AD_SHOW_FINAL = "is_ad_show_final"


    // =============================================================================================


    /**
     * 竞价结果
     */
    fun biddingReport(
        triggerId: String = "",           // 触发ID
        sceneId: String,                  // 场景ID
        @MbAdType adType: Int,            // 广告类型
        result: BiddingStateEnum?,        // 竞价结果
        msg: String?,                     // 失败原因
        ecpmList: String?,                // 参与竞价的列表
        ecpm: String?,                    // ecpm
        planId: String?,                  // 广告计划ID
        planName: String?                 // 广告计划名字
    ) {
        val map = mutableMapOf<String, String?>()
        map[AD_MAP_ACTION] = "bidding"
        map[AD_MAP_TRIGGER_ID] = triggerId
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_SCENE_ID] = sceneId
        map["result"] = result?.value
        map["msg"] = msg
        map["ecpm_list"] = ecpmList
        map["ecpm"] = ecpm
        map["plan_id"] = planId
        map["plan_name"] = planName
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 广告加载拒绝
     */
    fun reject(
        triggerId: String = "",
        sceneId: String,
        @MbAdType adType: Int,
        @MbAdSource adSource: Int,
        rejectMsg: String?,
    ) {
        val map = mutableMapOf<String, String?>()
        map[AD_MAP_ACTION] = "reject"
        map[AD_MAP_TRIGGER_ID] = triggerId
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_SCENE_ID] = sceneId
        map["reject_msg"] = rejectMsg
        map[AD_MAP_AD_SOURCE] = adSource.toString()
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 业务场景触发 -- 这里指的是业务场景触发展示广告不是加载
     */
    fun trigger(
        triggerId: String = "",
        sceneId: String,
        @MbAdType adType: Int,
        @MbAdSource adSource: Int,
        planId: String?
    ) {
        val map = mutableMapOf<String, String?>()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_TRIGGER
        map[AD_MAP_AD_TYPE] = adType.toString()
        //map[AD_MAP_PAGE_NAME] = sceneId 2075版本开始废弃了
        map[AD_MAP_SCENE_ID] = sceneId
        map[AD_MAP_PLAN_ID] = planId
        map[AD_MAP_AD_SOURCE] = adSource.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 广告展示 -- 依赖广告SDK回调
     */
    fun display(
        triggerId: String = "",
        sceneId: String?,
        adPlanId: String?,
        adSource: Int?,
        adId: String?,
        @MbAdType adType: Int,
        isAdShowFinal: Boolean = false,
        extMap: Map<String, String> = emptyMap(),
        psId: Long?,
        psPackageName: String? = null,
        bidEcpmCent: Double? = null,
        ecpmCent: Long? = null
    ) {
        val map = mutableMapOf<String, String?>()
        map[AD_MAP_AD_SOURCE] = adSource.toString()
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_DISPLAY
        map[AD_MAP_AD_ID] = adId ?: ""
        map[AD_MAP_AD_PLAN_ID] = adPlanId ?: ""
        map[AD_MAP_SCENE_ID] = sceneId ?: ""
        map[AD_MAP_IS_AD_SHOW_FINAL] = isAdShowFinal.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId
        map["ps_id"] = psId.toString()
        map["ps_package_name"] = psPackageName.toString()

        // ecpm
        map["bid_ecpm_cent"] = bidEcpmCent.toString()
        map["ecpm_cent"] = ecpmCent.toString()

        if (extMap.isNotEmpty()) {
            map.putAll(extMap)
        }
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 广告点击了 -- 依赖广告SDK回调
     */
    fun adClick(
        triggerId: String = "",
        sceneId: String?,
        adPlanId: String?,
        adSource: Int?,
        adId: String?,
        @MbAdType adType: Int,
        isAdShowFinal: Boolean = false,
        extMap: Map<String, String> = emptyMap(),
        psId: Long?,
        psPackageName: String? = null,
        bidEcpmCent: Double? = null,
        ecpmCent: Long? = null
    ) {
        val map = mutableMapOf<String, String?>()
        map[AD_MAP_AD_SOURCE] = adSource.toString()
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_CLICK
        map[AD_MAP_AD_ID] = adId ?: ""
        map[AD_MAP_AD_PLAN_ID] = adPlanId ?: ""
        map[AD_MAP_SCENE_ID] = sceneId ?: ""
        map[AD_MAP_IS_AD_SHOW_FINAL] = isAdShowFinal.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId
        map["ps_id"] = psId.toString()
        map["ps_package_name"] = psPackageName.toString()

        // ecpm
        map["bid_ecpm_cent"] = bidEcpmCent.toString()
        map["ecpm_cent"] = ecpmCent.toString()

        if (extMap.isNotEmpty()) {
            map.putAll(extMap)
        }
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * - 广告平均单次展现时长
     */
    fun adShowTime(
        triggerId: String = "",
        sceneId: String?,
        adPlanId: String?,
        displayTime: Long,
        adId: String?,
        @MbAdType adType: Int,
        isAdShowFinal: Boolean = false
    ) {
        val map = mutableMapOf<String, String?>()
        map[AD_MAP_AD_SOURCE] = MbAdSource.MB_AD_SOURCE_BUY_OUT.toString()
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_SHOW_TIME
        map[AD_MAP_AD_ID] = adId ?: ""
        map[AD_MAP_AD_PLAN_ID] = adPlanId ?: ""
        map[AD_MAP_SCENE_ID] = sceneId ?: ""
        map[AD_MAP_IS_AD_SHOW_FINAL] = isAdShowFinal.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId
        map["duration"] = displayTime.toString()
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 广告计划触达率
     *
     * 客户端接收到服务端，服务端去重DAU
     *
     * @param newVersion 当前字幕版本号
     */
    fun onNewAdPlanReceive(newVersion: String?, lastVersion: String?) {
        val map = mutableMapOf<String, String?>()
        map["new_version"] = newVersion.toString()
        map["last_version"] = lastVersion.toString()
        map[AD_MAP_ACTION] = "receive"
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = "ad_config"
        )
    }

    /**
     * 广告计划更新率
     *
     * 新版本字幕更新成功上报埋点，服务端去重DAU
     *
     * @param version 当前字幕版本号
     */
    fun onNewAdPlanUpdateSuccess(version: String?) {
        val map = mutableMapOf<String, String?>()
        map["version"] = version.toString()
        map[AD_MAP_ACTION] = "success"
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = "ad_config"
        )
    }
}