package com.transsion.ad.scene

import com.google.gson.JsonObject
import com.transsion.ad.MbAdContents

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 15:40
 * @description: 将通用配置提前保存到MMKV中方便获取 通用字断获取
 */
object SceneCommonConfig {


    // =============================== 下面是具体场景配置 =============================================


    /**
     * 下面是通用的配置key
     */

    private const val SCENE_CONFIG_KEY_HI_ID = "hiId"

    /**
     * 场景配置 -- 热启动开屏间隔时间 单位是分钟
     */
    const val SCENE_CONFIG_KEY_HOT_SPLASH_INTERVAL = "hotSplashInterval"

    /**
     * 场景配置 -- 刷新间隔
     */
    const val SCENE_CONFIG_KEY_DOWNLOAD_ACCUMULATIVE_SHOW_TIME = "downloadAccumulativeShowTime"


    // =============================================================================================


    /**
     * 通过场景ID获取HiSavana广告的广告位ID
     */
    fun getHiSavanaPlacementId(sceneId: String?): String? {

        // TODO 测试代码
        // Native
//        if (TextUtils.equals(sceneId, "DownloadListScene")) {
//            return "230710gmb3Wdk4"
//        }
//        // 激励视频
//        if (TextUtils.equals(sceneId, "")) {
//            return "2307102tni8MB7"
//        }
//        // 插屏
//        if (TextUtils.equals(sceneId, "HotStartScene")) {
//            return "230710g3PPp6Rb"
//        }

        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(sceneId)
            sceneConfig?.get(SCENE_CONFIG_KEY_HI_ID)?.asString
        }.getOrElse {
            null
        }
    }

    fun getHiSavanaPlacementId(sceneConfig: JsonObject?): String? {
        return kotlin.runCatching {
            sceneConfig?.get(SCENE_CONFIG_KEY_HI_ID)?.asString
        }.getOrElse {
            null
        }
    }


    // ================================= 通用字段 ============================================================


    /**
     * 获取场景配置的X
     */
    fun getSceneX(sceneId: String, default: Int = 5): Int {
        return kotlin.runCatching {
            SceneStorage.getSceneConfig(sceneId)?.get("x")?.asInt ?: default
        }.getOrElse {
            default
        }
    }

    /**
     * 获取场景配置的Y
     */
    fun getSceneY(sceneId: String, default: Int = 5): Int {
        return kotlin.runCatching {
            SceneStorage.getSceneConfig(sceneId)?.get("y")?.asInt ?: default
        }.getOrElse {
            default
        }
    }

    /**
     * 获取刷新时间
     * "refreshTime": 30         // 单位秒
     */
    fun getRefreshTime(sceneId: String?): Int {
        return SceneStorage.getSceneConfig(sceneId)?.get("refreshTime")?.asInt ?: 30
    }

    /**
     * 获取页面样式
     */
    fun getAdActivityStyle(sceneId: String?): String {
        return SceneStorage.getSceneConfig(sceneId)?.get("adActivityStyle")?.asString ?: ""
    }


    // =============================================================================================


    /**
     * 获取 SCENE_LOCAL_VIDEO_BACK_INTERSTITIAL_V2 内部字段 interval
     * 	{
     * 		"id": "LocalVideoBackInterstitialV2Scene",
     * 		"sceneOff": false,
     * 		"nonOff": false,
     * 		"hiId": "240607d1e5EC2g",
     * 		"hiOff": false,
     * 		"interval": 10 // 分钟
     * 	}
     */
    fun getInterval(sceneId: String): Int {
        return SceneStorage.getSceneConfig(sceneId)?.get("interval")?.asInt ?: 10
    }

    fun getPsPullModel(sceneId: String): String {
        return SceneStorage.getSceneConfig(sceneId)?.get("pullModel")?.asString ?: ""
    }

    /**
     * 获取竞价时间
     * 单位秒
     */
    fun getBiddingTime(sceneId: String): Int {
        return SceneStorage.getSceneConfig(sceneId)?.get("biddingTime")?.asInt ?: 2
    }

    /**
     * 获取开屏广告倒计时
     */
    fun getSplashCountDown(sceneId: String): Int {
        // 开屏倒计时是可配置的
        return kotlin.runCatching {
            val config = SceneStorage.getSceneConfig(sceneId)
            config?.get("countDown")?.asInt ?: MbAdContents.DEFAULT_COUNT_DOWN_SECONDS
        }.getOrElse {
            MbAdContents.DEFAULT_COUNT_DOWN_SECONDS
        }
    }

    /**
     * 获取开屏广告超时时间
     */
    fun getSplashTimeOut(sceneId: String): Int {
        // 开屏倒计时是可配置的
        return kotlin.runCatching {
            val config = SceneStorage.getSceneConfig(sceneId)
            config?.get("timeOut")?.asInt ?: MbAdContents.DEFAULT_COUNT_DOWN_SECONDS
        }.getOrElse {
            MbAdContents.DEFAULT_COUNT_DOWN_SECONDS
        }
    }

    /**
     * 获取首页二楼广告第一次停顿时间
     */
    fun getTrendingTwoLevelFirstPauseTime(sceneId: String): Int {
        return kotlin.runCatching {
            val config = SceneStorage.getSceneConfig(sceneId)
            config?.get("firstPause")?.asInt ?: 300
        }.getOrElse {
            300
        }
    }

    fun getTrendingTwoLevelSecondPauseTime(sceneId: String): Int {
        return kotlin.runCatching {
            val config = SceneStorage.getSceneConfig(sceneId)
            config?.get("secondPause")?.asInt ?: 800
        }.getOrElse {
            800
        }
    }
}