package com.transsion.ad.scene

import com.transsion.ad.strategy.AdUrlParameterManager
import org.json.JSONArray


/**
 * @author: zhangxinbing
 * @date : 2025/2/17 10:42
 * @description:全局场景 全局场景配置更新之后这里需要同步更新
 * https://transsioner.feishu.cn/wiki/UJKSwddQgiBWeVkgEJUcPPEGnMf
 */
object SceneGlobalConfig {

    /***全局配置*/
    const val SCENE_GLOB_CONFIG = "GlobConfigScene"

    /**
     * 获取全局场景ID
     */
    private fun getGlobalSceneId(): String = SCENE_GLOB_CONFIG


    /**
     * 广告链接宏替换配置
     */
    fun getUrlParameterReplace(): List<AdUrlParameterManager.UrlParameterReplaceEntity> {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            val urlParameterReplaceString = sceneConfig?.get("urlParameterReplace")?.asString
            // 解析 urlParameterReplace 字符串为 JSON 数组
            val urlParameterReplaceArray = JSONArray(urlParameterReplaceString)
            // 遍历解析后的数组
            val list = mutableListOf<AdUrlParameterManager.UrlParameterReplaceEntity>()
            for (i in 0 until urlParameterReplaceArray.length()) {
                val item = urlParameterReplaceArray.getJSONObject(i)
                // 打印每个参数的信息
                //println("Key: $key, Value: $value, Type: $type")
                list.add(
                    AdUrlParameterManager.UrlParameterReplaceEntity(
                        key = item.getString("key"),
                        value = item.getString("value"),
                        type = item.getString("type")
                    )
                )
            }
            list
        }.getOrElse {
            emptyList()
        }
    }

    /**
     * 包断广告是否展示AD标识
     */
    fun isShowAdTag(): Boolean {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            sceneConfig?.get("showAdTag")?.asBoolean ?: false
        }.getOrElse {
            false
        }
    }

    /**
     * 获取插屏倒计时时间
     */
    fun getInterstitialCd(): Int {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            sceneConfig?.get("interstitialCd")?.asInt ?: 5
        }.getOrElse {
            5
        }
    }

    /**
     * 获取激励视频倒计时时间
     */
    fun getVideoCd(): Int {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            sceneConfig?.get("videoCd")?.asInt ?: 15
        }.getOrElse {
            15
        }
    }

    /**
     * 服务端配置的限制Android系统内存初始化广告SDK
     */
    fun getLowMemoryValue(): Float {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            sceneConfig?.get("lowMemoryValue")?.asFloat ?: 1.0f
        }.getOrElse {
            1.0f
        }
    }

    /**
     * 广告部分埋点上报开关
     */
    fun isAdLinkClosed(): Boolean {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            sceneConfig?.get("adLinkOff")?.asBoolean ?: false
        }.getOrElse {
            false
        }
    }

    /**
     * 全局控制是否打开关闭广告
     *
     * "isOpenAd": true,
     */
    fun isOpenAd(): Boolean {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            sceneConfig?.get("isOpenAd")?.asBoolean ?: true
        }.getOrElse {
            true
        }
    }

    /**
     * 获取原生广告缓存池大小
     */
    fun getNativeCacheUpperLimit(): Int {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            sceneConfig?.get("nativeCacheUpperLimit")?.asInt ?: 1
        }.getOrElse {
            1
        }
    }

    /**
     * 获取新用户保护时间 -- 单位是天 默认是5天
     */
    private fun getNewUserMaskTime(): Long {
        // 当服务端设置小与0的数值，那将一直屏蔽
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            (sceneConfig?.get("newUserMaskTime")?.asInt ?: 5) * 24 * 60 * 60 * 1000L
        }.getOrElse {
            5 * 24 * 60 * 60 * 1000L
        }
    }

    /**
     * 获取PS接口间隔时间
     *
     * 默认 60秒
     */
    fun getPsLinkInterval(): Int {
        // 当服务端设置小与0的数值，那将一直屏蔽
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(getGlobalSceneId())
            (sceneConfig?.get("psLinkInterval")?.asInt ?: 6)
        }.getOrElse {
            6
        }
    }
}