package com.transsion.ad.strategy

import android.net.Network
import android.net.NetworkCapabilities
import com.tn.lib.util.networkinfo.NetworkUtil
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener
import com.transsion.ad.AdLogger
import com.transsion.ad.monopoly.MonopolyAdManager
import com.transsion.ad.ps.attribution.AttributionConsumeManager
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import java.util.concurrent.atomic.AtomicBoolean

/**
 * @author: zhangxinbing
 * @date : 2025/5/22 20:25
 * @description: 网络状态监听
 */
class AdObserveNetworkState : OnNetworkStatusChangedListener {

    private var adConfigUrl: String? = "" // 请求Path
    private var isLoading: AtomicBoolean = AtomicBoolean(false) // 是否正在请求
    private var result: Boolean = false // 生命周期内是否请求成功
    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    fun registerNetworkStatusChangedListener(adConfigUrl: String) {
        this.adConfigUrl = adConfigUrl
        AdLogger.logAdInit("${getClassTag()} --> registerNetworkStatusChangedListener() --> 网络变化监听 success")
        NetworkUtil.registerNetworkStatusChangedListener(this)
    }

    override fun onConnected(network: Network, networkCapabilities: NetworkCapabilities) {

        // 归因上报
        AttributionConsumeManager.consume()

        if (isLoading.get()) {
            AdLogger.logAdInit("${getClassTag()} --> onConnected() --> isLoading == true")
            return
        }
        isLoading.set(true)

        if (result) {
            AdLogger.logAdInit("${getClassTag()} --> onConnected() --> result == true --> 生命周期内已经请求成功")
            return
        }

        CoroutineScope(Dispatchers.IO).launch {
            delay(500)
            AdLogger.logAdInit("${getClassTag()} --> onConnected() --> 网络变化，请求广告配置")
            MonopolyAdManager.init(adConfigUrl ?: "") { result ->
                this@AdObserveNetworkState.result = result
                // 请求失败了，继续请求
                AdLogger.logAdInit("${getClassTag()} --> onConnected() --> 广告请求结果--> result == $result")
                isLoading.set(false)
            }
        }
    }

    override fun onDisconnected() {}

}