package com.transsion.ad.strategy

import android.text.TextUtils
import com.transsion.ad.AdLogger
import com.transsion.ad.http.OkHttpProvider
import okhttp3.Request
import okhttp3.Response
import java.io.BufferedInputStream
import java.io.FileOutputStream

/**
 * @author: zhangxinbing
 * @date : 2025/2/18 20:46
 * @description: 广告资源下载
 */
internal object AdResDownloadManager {

    private fun getClassTag(): String = javaClass.simpleName

    /**
     * 广告资源下载
     *
     * // Usage
     * val fileUrl = "https://example.com/file.txt"
     * val destinationPath = "/path/to/save/file.txt"
     * downloadFile(fileUrl, destinationPath)
     */
    fun downloadFile(url: String?, destination: String): Boolean {
        if (TextUtils.isEmpty(url)) {
            return false
        }

        kotlin.runCatching {
            val request = Request.Builder().url(url ?: "").build()
            val response: Response = OkHttpProvider.getOkHttpClient().newCall(request).execute()
            if (response.isSuccessful.not()) {
                AdLogger.logAdInitE("${getClassTag()} --> downloadFile() --> 素材加载失败 --> destination = $destination --> response = ${response.message} --> url = $url")
                return false
            }
            response.body?.byteStream().use { inputStream ->
                BufferedInputStream(inputStream).use { bis ->
                    FileOutputStream(destination).use { fos ->
                        val buffer = ByteArray(1024 * 4)
                        var bytesRead: Int
                        while (bis.read(buffer).also { bytesRead = it } != -1) {
                            fos.write(buffer, 0, bytesRead)
                        }
                    }
                }
            }
            return true
        }.getOrElse {
            // 广告加载失败
            AdLogger.logAdInitE("${getClassTag()} --> downloadFile() --> 素材加载失败 --> destination = $destination --> it = $it --> url = $url")
            return false
        }
    }
}