package com.transsion.ad.strategy

import com.transsion.ad.AdLogger
import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.ad.scene.SceneStorage
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author: zhangxinbing
 * @date : 2025/2/14 16:33
 * @description: 新用户管理
 */
internal object NewUserManager {

    /***新用户第一次使用的时间戳*/
    private const val MMKV_KEY_NEW_USER_FIRST_USE_TIME_STAMP =
        "mmkv_key_new_user_first_use_time_stamp"

    /*** 新用户前三天不展示广告 ，数据本地保存，如果清理缓存了会有影响。*/
    fun isNewUserMask(): Boolean {
        // 第一次安装时间戳
        val timestamp = AdMmkv.getAdMMKV().getLong(MMKV_KEY_NEW_USER_FIRST_USE_TIME_STAMP, -1L)
        val gap = System.currentTimeMillis() - timestamp
        val newUserMaskTime = getNewUserMaskTime()
        return gap <= newUserMaskTime
    }

    /***初始化本地数据*/
    suspend fun initFirstOpen() {
        withContext(Dispatchers.IO) {
            val timestamp = AdMmkv.getAdMMKV().getLong(MMKV_KEY_NEW_USER_FIRST_USE_TIME_STAMP, -1L)
            if (timestamp < 0) {
                AdMmkv.getAdMMKV().putLong(
                    MMKV_KEY_NEW_USER_FIRST_USE_TIME_STAMP, System.currentTimeMillis()
                )
            }
            AdLogger.logAdInit("NewUserManager --> initFirstOpen() --> isNewUserMask = ${isNewUserMask()} ")
        }
    }

    /**
     * 获取新用户保护时间 -- 单位是天 默认是5天
     */
    private fun getNewUserMaskTime(): Long {
        // TODO 当服务端设置小与0的数值，那将一直屏蔽
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(SceneGlobalConfig.SCENE_GLOB_CONFIG)
            (sceneConfig?.get("newUserMaskTime")?.asInt ?: 5) * 24 * 60 * 60 * 1000L
        }.getOrElse {
            5 * 24 * 60 * 60 * 1000L
        }
    }

}