package com.transsion.ad.test

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.AdLogger
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.banner.BiddingBannerManager
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.databinding.ActivityTestAdBannerLayoutBinding
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/5 17:17
 * @description:
 */
class TestAdBannerActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTestAdBannerLayoutBinding
    private var bannerManager: BiddingBannerManager? = null

    private val bannerListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            lifecycleScope.launch {
                maxEcpmObject?.bannerView?.let {
                    bannerManager?.showBannerAd()
                    binding.flBannerContainer.addView(it)
                }
            }
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            AdLogger.logSdkBannerE("Banner 广告加载失败")
        }
    }


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdBannerLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.btnLoadBannerAd.setOnClickListener {
            lifecycleScope.launch {
                bannerManager?.destroy()
                bannerManager = BiddingBannerManager()
                bannerManager?.setSceneId("TrendingBannerScene")
                bannerManager?.setCtxMap(null)
                bannerManager?.setContext(this@TestAdBannerActivity)
                bannerManager?.setListener(bannerListener)
                bannerManager?.loadAd()
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        bannerManager?.destroy()
    }

}