package com.transsion.ad.test

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.AdLogger
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.interstitial.BiddingInterstitialManager
import com.transsion.ad.databinding.ActivityTestAdInterstitialLayoutBinding
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 10:43
 * @description:
 */
class TestAdInterstitialActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTestAdInterstitialLayoutBinding
    private lateinit var interstitialManager: BiddingInterstitialManager
    private fun getClassTag(): String = javaClass.simpleName

    private val interstitialListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            //AdLogger.logSdkBannerE("${getClassTag()} --> onBiddingLoad() --> 广告加载完成，可以展示了")
            interstitialManager.startAdActivity(this@TestAdInterstitialActivity)
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            AdLogger.logSdkBannerE("${getClassTag()} --> onBiddingError() --> p0 = ${p0?.errorMessage}")
        }
    }


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdInterstitialLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        interstitialManager = BiddingInterstitialManager()
        binding.btnLoadInterstitialAd.setOnClickListener {
            lifecycleScope.launch {
                interstitialManager.setSceneId("HotStartScene")
                interstitialManager.setCtxMap(null)
                interstitialManager.setContext(this@TestAdInterstitialActivity)
                interstitialManager.setListener(interstitialListener)
                interstitialManager.loadAd()
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        interstitialManager.destroy()
    }

}