package com.transsion.ad.test

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.blankj.utilcode.util.GsonUtils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.ad.AdLogger
import com.transsion.ad.R
import com.transsion.ad.config.TestConfig
import com.transsion.ad.databinding.ActivityTestAdPsOfferLayoutBinding
import com.transsion.ad.db.MbAdDatabase
import com.transsion.ad.db.pslink.PsLinkAdPlan
import com.transsion.ad.ps.model.PSAdTypeEnum
import com.transsion.ad.ps.model.RecommendInfo
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * @author shmizhangxinbing
 * @date : 2025/7/10 15:00
 * @description:
 */
class TestAdPsOfferActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTestAdPsOfferLayoutBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdPsOfferLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        val mAdPlanAdapter = AdPlansAdapter()
        binding.rv.apply {
            layoutManager = LinearLayoutManager(this@TestAdPsOfferActivity)
            adapter = mAdPlanAdapter
        }

        lifecycleScope.launch {
            withContext(Dispatchers.IO) {
                val allPslink =
                    MbAdDatabase.getInstance(this@TestAdPsOfferActivity).psLinkAdPlanDao()
                        .getAllPslink()
                withContext(Dispatchers.Main) {
                    mAdPlanAdapter.setList(allPslink)
                    val tvTitle = "计划数量 = ${allPslink?.size.toString()}"
                    binding.tvConfig.text = tvTitle
                }
            }
        }

        // 按钮处理
        showBtn()

        binding.btn.setOnClickListener {
            TestConfig.setReleasePsApi(TestConfig.isReleasePsApi().not())
            showBtn()
        }

        binding.btnLogger.setOnClickListener {
            lifecycleScope.launch {
                withContext(Dispatchers.IO) {
                    val allPslink =
                        MbAdDatabase.getInstance(this@TestAdPsOfferActivity).psLinkAdPlanDao()
                            .getAllPslink()
                    val toJson = GsonUtils.getGson().toJson(allPslink)
                    AdLogger.logSdk("TestAdPsOfferActivity --> toJson = $toJson")
                }
            }
        }

    }

    private fun showBtn() {
        binding.btn.text = if (TestConfig.isReleasePsApi()) {
            "releasePsApi = true"
        } else {
            "releasePsApi = false"
        }
    }


    // =============================================================================================


    class AdPlansAdapter :
        BaseQuickAdapter<PsLinkAdPlan, BaseViewHolder>(R.layout.test_item_ad_plan_layout) {

        override fun convert(holder: BaseViewHolder, item: PsLinkAdPlan) {

            val sb = StringBuilder()
            val psRecommendInfo = GsonUtils.fromJson(item.psInfoJson, RecommendInfo::class.java)

            sb.append("id = ${item.id}\n").append("nonId = ${item.nonId}\n")
                .append("adSource = ${item.adSource}\n").append("extAdSlot = ${item.extAdSlot}\n")
                .append("rank = ${item.rank}\n").append("psPlanId = ${item.psPlanId}\n")
                .append("packageName = ${psRecommendInfo.packageName}\n")
                .append("name = ${psRecommendInfo.detail?.name}\n")
                .append("updateTimestamp = ${item.updateTimestamp}\n")

                .append("showAttributionLink = ${psRecommendInfo.showAttributionLink}\n")
                .append("attributionLink = ${psRecommendInfo.attributionLink}\n")
                .append("deepLink = ${psRecommendInfo.deepLink}\n")
                .append("gpLink = ${psRecommendInfo.gpLink}\n")

            if (psRecommendInfo.adType == PSAdTypeEnum.PS_AD_TYPE_USER_RETENTION_1.value) {
                sb.append("adType = 拉活\n")
            } else {
                sb.append("adType = 拉新\n")
            }

            // 展示
            holder.setText(R.id.tvConfig, sb.toString())
        }
    }

}