package com.transsion.ad.test

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.AdLogger
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.video.BiddingVideoManager
import com.transsion.ad.databinding.ActivityTestAdVideoLayoutBinding
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 10:42
 * @description:
 */
class TestAdVideoActivity : AppCompatActivity() {

    private lateinit var videoManager: BiddingVideoManager
    private lateinit var binding: ActivityTestAdVideoLayoutBinding
    private fun getClassTag(): String = javaClass.simpleName

    private val videoListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            videoManager.startAdActivity(this@TestAdVideoActivity)
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            AdLogger.logSdkBannerE("${getClassTag()} --> onBiddingError() --> p0 = ${p0?.errorMessage}")
        }
    }


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdVideoLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        videoManager = BiddingVideoManager()
        binding.btnLoadVideoAd.setOnClickListener {
            lifecycleScope.launch {
                videoManager.setSceneId("MemberPageVideoTaskScene")
                videoManager.setCtxMap(null)
                videoManager.setContext(this@TestAdVideoActivity)
                videoManager.setListener(videoListener)
                videoManager.loadAd()
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        videoManager.destroy()
    }

}