package com.transsion.ad.util

import com.transsion.ad.AdLogger

/**
 * @author: zhangxinbing
 * @date : 2025/5/8 16:48
 * @description: 异常捕获
 */
object AdRunCatching {

    inline fun <R> runCatching(block: () -> R): Result<R> {
        return try {
            Result.success(block())
        } catch (e: Throwable) {
            AdLogger.logCatching(e) // 统一输出错误信息
            Result.failure(e)
        }
    }
}