package com.transsion.ad.util

import android.content.Context
import android.util.Log
import com.blankj.utilcode.util.Utils
import com.transsion.ad.AdLogger
import java.io.BufferedReader
import java.io.File
import java.io.FileOutputStream
import java.io.IOException
import java.io.InputStreamReader

/**
 * @author: zhangxinbing
 * @date : 2025/2/13 16:37
 * @description:
 */
internal object AssetsUtil {

    /**
     * 读取assets中的文件
     */
    fun readAssets(fileName: String): String {
        // 从assets中读取配置文件
        // 读取本地的 fileName.json 文件
        var br: BufferedReader? = null
        try {
            // 读取文件内容 (输入流)
            br = BufferedReader(
                InputStreamReader(
                    Utils.getApp().resources.assets.open(fileName)
                )
            )
            var line: String?
            val sb = StringBuilder()
            while (br.readLine().also { line = it } != null) {
                sb.append(line)
            }
            br.close()
            return sb.toString()
        }
        // 将异常抛出去，调用的地方处理
        finally {
            br?.close()
        }
    }


    /**
     * 将assets中的文件复制到下载目录中
     */
    fun copyAssetFile(context: Context, assetFileName: String, destinationFile: File): Boolean {
        try {
            val inputStream = context.assets.open(assetFileName)
            val outputStream = FileOutputStream(destinationFile)
            inputStream.copyTo(outputStream)
            inputStream.close()
            outputStream.close()
            return true
        } catch (e: IOException) {
            AdLogger.logSdkE(
                "AssetsUtil --> copyAssetFile() --> 复制失败 --> e = ${
                    Log.getStackTraceString(
                        e
                    )
                }"
            )
            return false
        }
    }

}