package com.transsion.ad.util

import android.content.Context
import android.graphics.Bitmap
import android.graphics.drawable.Drawable
import com.bumptech.glide.Glide
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.load.resource.gif.GifDrawable
import com.bumptech.glide.request.target.CustomTarget
import com.bumptech.glide.request.transition.Transition
import com.transsion.ad.AdLogger

/**
 * @author: zhangxinbing
 * @date : 2024/8/15 14:09
 * @description: 图片工具类
 */
object ImageUtils {

    /**
     * 下载图片
     */
    fun downloadImage(
        context: Context,
        imageUrl: String?,
        onLoadFailed: () -> Unit,
        onResourceReady: (resource: Bitmap?) -> Unit
    ) {
        Glide.with(context).asBitmap().diskCacheStrategy(DiskCacheStrategy.ALL) // 添加缓存策略
            .load(imageUrl).into(object : CustomTarget<Bitmap?>() {
                override fun onResourceReady(
                    resource: Bitmap, transition: Transition<in Bitmap?>?
                ) {
//                    AdLogger.logSdk(
//                        "ImageUtils --> downloadImage() --> onResourceReady() --> 图片加载成功 --> imageUrl = $imageUrl",
//                        writeToFile = false
//                    )
                    onResourceReady.invoke(resource)
                }

                override fun onLoadCleared(placeholder: Drawable?) {}

                override fun onLoadFailed(errorDrawable: Drawable?) {
                    super.onLoadFailed(errorDrawable)
//                    AdLogger.logSdk(
//                        "ImageUtils --> downloadImage() --> onLoadFailed() --> imageUrl = $imageUrl",
//                        writeToFile = false
//                    )
                    onLoadFailed.invoke()
                }
            })
    }

    /**
     * 下载Gif图片
     */
    fun downloadGif(
        context: Context,
        imageUrl: String?,
        onLoadFailed: () -> Unit,
        onResourceReady: (resource: GifDrawable?) -> Unit
    ) {
        Glide.with(context).asGif().diskCacheStrategy(DiskCacheStrategy.ALL) // 添加缓存策略
            .load(imageUrl).into(object : CustomTarget<GifDrawable?>() {
                override fun onResourceReady(
                    resource: GifDrawable, transition: Transition<in GifDrawable?>?
                ) {
//                    AdLogger.logSdk(
//                        "ImageUtils --> downloadGif() --> onResourceReady() --> 图片加载成功 --> imageUrl = $imageUrl",
//                        writeToFile = false
//                    )
                    onResourceReady.invoke(resource)
                }

                override fun onLoadCleared(placeholder: Drawable?) {}

                override fun onLoadFailed(errorDrawable: Drawable?) {
                    super.onLoadFailed(errorDrawable)
//                    AdLogger.logSdk(
//                        "ImageUtils --> downloadGif() --> onLoadFailed() --> imageUrl = $imageUrl",
//                        writeToFile = false
//                    )
                    onLoadFailed.invoke()
                }
            })
    }

}