package com.transsion.ad.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.FrameLayout
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.strategy.MeasureManager
import java.util.concurrent.atomic.AtomicBoolean

/**
 * @author: zhangxinbing
 * @date : 2025/5/27 11:37
 * @description: 自定义包断广告 当前仅处理曝光展示时间监测
 */
abstract class AbsBuyOutNativeView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null
) : FrameLayout(context, attrs), MeasureManager.ViewVisibilityListener {

    protected fun getClassTag(): String = javaClass.simpleName

    private var showTime = 0L // 广告开始展示的时间 时间戳 毫秒
    private var isReportAdDisplay: AtomicBoolean = AtomicBoolean(false) // 是否已经上报过一次曝光了
    private var mSceneId: String? = null
    protected var mCallback: WrapperAdListener? = null


    // =============================== 广告View 曝光监测 =============================================


    override fun onVisibilityChanged(isVisible: Boolean) {
        if (isVisible) {
            // 开始展示的时间
            if (showTime == 0L) {
                showTime = System.currentTimeMillis()
            }

            // 曝光上报
            if (isReportAdDisplay.get().not()) {
                isReportAdDisplay.set(true)
                display()
            }
        } else {
            adShowTime()
        }
    }

    override fun getVisibilityView(): View? = this


    // =============================================================================================


    /**
     * 广告曝光回调
     */
    abstract fun display()

    /**
     * 广告累计时间回调
     */
    abstract fun adShowTime()


    // =============================================================================================


    fun setCallback(callback: WrapperAdListener?) {
        mCallback = callback
    }

    fun setSceneId(sceneId: String?) {
        mSceneId = sceneId
    }

    fun getSceneId(): String = mSceneId ?: ""

    fun getWrapperAdListener(): WrapperAdListener? = mCallback

}