package com.transsion.ad.view.native_ad

import android.app.Activity
import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.transsion.ad.AdLogger
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.strategy.AdTagManager
import com.transsion.ad.view.AdTagView
import com.transsion.ad.view.blur.BlurTransformation

/**
 * @author shmizhangxinbing
 * @date : 2025/5/29 17:45
 * @description:
 */
class BiddingBuyOutNativeView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
) : AbsBiddingBuyOutView(context, attrs) {


    private var adProviderBean: BiddingAdLayoutProviderBean? = null
    private var mIsShowVolumeIcon: Boolean = true


    // =============================================================================================


    override fun getMediaContainer(): FrameLayout? {
        adProviderBean?.mediaId?.let { mediaId ->
            return adProviderBean?.layout?.findViewById(mediaId)
        }
        return null
    }

    override fun isShowVolumeIcon(): Boolean = mIsShowVolumeIcon


    // =============================================================================================


    /**
     * 渲染视图
     */
    fun bindNativeView(adLayoutProvider: AbsBiddingAdLayoutProvider?) {

        // 数据校验
        if (getAdPlans() == null || adLayoutProvider == null) {
            return
        }

        val adProviderBean = adLayoutProvider.getAdLayoutProvider()
        this.adProviderBean = adProviderBean
        this.mIsShowVolumeIcon = adLayoutProvider.isShowVolumeIcon()

        // 修复线上问题
        // 在Android中使用Glide加载图片时，如果传入的context是view的context，可能会导致上述的IllegalArgumentException。
        // 这是因为view的context可能与Activity的生命周期不同步。
        // Exception java.lang.IllegalArgumentException: You cannot start a load for a destroyed activity
        // at com.bumptech.glide.manager.RequestManagerRetriever.assertNotDestroyed (RequestManagerRetriever.java:353)
        // at com.bumptech.glide.manager.RequestManagerRetriever.get (RequestManagerRetriever.java:153)
        // at com.bumptech.glide.manager.RequestManagerRetriever.get (RequestManagerRetriever.java:133)
        // at com.bumptech.glide.Glide.with (Glide.java:818)
        // at com.transsion.wrapperad.middle.nativead.NonNativeView.showData (NonNativeView.kt:266)
        if ((context as? Activity)?.isDestroyed == true) {
            AdLogger.logSdkNative(
                "${getClassTag()} --> 当前Activity销毁，广告就不需要展示了", writeToFile = false
            )
            return
        }

        //设置标题
        setTitle(adProviderBean)
        // 设置描述
        setDescription(adProviderBean)
        // 按钮文案点击事件
        setCallToAction(adProviderBean)
        // 广告主头像
        setAdAvatar(adProviderBean)
        // 展示媒体内容
        showMedia()
        // 高斯模糊背景
        if (getAdMaterialList()?.type == AdMaterialList.NON_AD_TYPE_TEXT) {
            showBlur(adProviderBean)
        }
        // AD 标识控制
        adProviderBean.adTagId?.let { adTagId ->
            adProviderBean.layout.findViewById<AdTagView>(adTagId)?.apply {
                AdTagManager.handleForAdTagView(this)
            }
        }

        // 组装View 将广告布局添加到容器中
        removeAllViews()
        addView(
            adProviderBean.layout, LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT
            )
        )
    }


    // =============================================================================================


    /**
     * 标题
     */
    private fun setTitle(adLayoutProvider: BiddingAdLayoutProviderBean?) {
        adLayoutProvider?.titleId?.let { titleId ->
            adLayoutProvider.layout.findViewById<TextView>(titleId)?.apply {
                text = getAdMaterialList()?.title
            }
        }
    }

    /**
     * 描述
     */
    private fun setDescription(adLayoutProvider: BiddingAdLayoutProviderBean?) {
        adLayoutProvider?.descriptionId?.let { descriptionId ->
            adLayoutProvider.layout.findViewById<TextView>(descriptionId)?.apply {
                text = getAdMaterialList()?.desc
            }
        }
    }

    /**
     * 点击事件
     */
    private fun setCallToAction(adLayoutProvider: BiddingAdLayoutProviderBean?) {
        adLayoutProvider?.callToActionId?.let { callToActionId ->
            adLayoutProvider.layout.findViewById<TextView>(callToActionId)?.apply {
                if (TextUtils.isEmpty(getAdMaterialList()?.buttonText)) {
                    getAdMaterialList()?.buttonText = "GO"
                }
                text = getAdMaterialList()?.buttonText
                setOnClickListener {
                    onAdClick()
                }
            }
        }

        // 广告点击事件
        adLayoutProvider?.layout?.setOnClickListener {
            onAdClick()
        }
    }

    /**
     * 广告主头像
     */
    private fun setAdAvatar(adLayoutProvider: BiddingAdLayoutProviderBean?) {
        adLayoutProvider?.iconId?.let { iconId ->
            adLayoutProvider.layout.findViewById<FrameLayout>(iconId)?.apply {
                removeAllViews()
                val imageView = ImageView(context)
                imageView.scaleType = ImageView.ScaleType.FIT_CENTER
                if (TextUtils.isEmpty(getAdPlans()?.advertiserAvatarPath)) {
                    Glide.with(context).load(getAdPlans()?.advertiserAvatar).fitCenter()
                        .into(imageView)
                } else {
                    Glide.with(context).load(getAdPlans()?.advertiserAvatarPath).fitCenter()
                        .into(imageView)
                }
                // 全屏展示
                addView(imageView)
            }
        }
    }

    /**
     * 模糊背景
     */
    private fun showBlur(adLayoutProvider: BiddingAdLayoutProviderBean?) {
        adLayoutProvider?.burlBgId?.let { mediaId ->
            val imageViewBlur = adLayoutProvider.layout.findViewById<ImageView>(mediaId)
            imageViewBlur.scaleType = ImageView.ScaleType.CENTER_CROP
            // 如果本地地址是空的，那就不使用线上地址在线加载
            val path = if (TextUtils.isEmpty(getAdMaterialList()?.image?.path)) {
                getAdMaterialList()?.image?.url
            } else {
                getAdMaterialList()?.image?.path
            }
            Glide.with(context).load(path).transform(BlurTransformation(25)).into(imageViewBlur)
        }
    }

}