package com.transsion.ad.view.native_ad

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.FrameLayout
import com.hisavana.mediation.ad.TAdNativeView
import com.transsion.ad.bidding.nativead.BiddingHiSavanaNativeProvider
import com.transsion.ad.bidding.nativead.BiddingNativeManager

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 17:29
 * @description: 原生广告封装一层
 */
class NativeWrapperAdView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
) : FrameLayout(context, attrs) {

    private fun getClassTag(): String = javaClass.simpleName
    private var buyoutNativeView: BiddingBuyOutNativeView? = null  // 包断广告 NativeView
    private var hiNativeView: TAdNativeView? = null  // Hi程序化 NativeView


    // =============================================================================================


    /**
     * 展示广告
     */
    fun bindNativeView(
        adManager: BiddingNativeManager?, // Native 广告加载对象
        adLayoutProvider: AbsBiddingAdLayoutProvider? // 布局信息
    ) {
        if (adManager == null || adLayoutProvider == null) {
            return
        }

        if (isHiAd(adManager)) {
            bindHiNativeAd(adManager, adLayoutProvider)
            buyoutNativeView?.visibility = View.GONE
            hiNativeView?.visibility = View.VISIBLE
        } else {
            bindBuyOutAd(adManager, adLayoutProvider)
            buyoutNativeView?.visibility = View.VISIBLE
            hiNativeView?.visibility = View.GONE
        }
    }


    // =============================================================================================


    /**
     * 判断当前是什么广告类型
     */
    private fun isHiAd(adManager: BiddingNativeManager?): Boolean {
        return adManager?.getMaxEcpmObject()?.nativeInfo != null
    }

    /**
     * 包断广告展示
     */
    private fun bindBuyOutAd(
        adManager: BiddingNativeManager?, adLayoutProvider: AbsBiddingAdLayoutProvider?
    ) {
        if (buyoutNativeView == null) {
            buyoutNativeView = BiddingBuyOutNativeView(context)
            addView(buyoutNativeView)
        } else {
            //AdLogger.logSdkNativeE("${getClassTag()} --> bindBuyOutAd() --> View 复用")
        }
        // 是否已经保管过了
        adManager?.isReportAdDisplay()?.let { isReportAdDisplay ->
            buyoutNativeView?.isReportAdDisplay(isReportAdDisplay)
        }
        buyoutNativeView?.setAdPlans(adManager?.getMaxEcpmObject()?.plans)
        buyoutNativeView?.bindNativeView(adLayoutProvider)
        buyoutNativeView?.setListener(adManager)
        adManager?.bindBuyOutNativeView(buyoutNativeView) // 资源回收使用
    }

    /**
     * Hi程序化广告展示
     */
    private fun bindHiNativeAd(
        adManager: BiddingNativeManager?, adLayoutProvider: AbsBiddingAdLayoutProvider?
    ) {

        if (hiNativeView == null) {
            hiNativeView = TAdNativeView(context)
            addView(hiNativeView)
        } else {
            //AdLogger.logSdkNativeE("${getClassTag()} --> bindHiNativeAd() --> View 复用")
        }

        adManager?.bindHiNativeView(hiNativeView) // 资源回收使用

        kotlin.runCatching {
            val nativeInfo = adManager?.getMaxEcpmObject()?.nativeInfo
            if (hiNativeView != null && adLayoutProvider != null && nativeInfo != null) {
                val hiViewBinder = adLayoutProvider.getHiViewBinder(
                    adLayoutProvider.getAdLayoutProvider(), adManager.getMaxEcpmObject()?.nativeInfo
                )
                val tNativeAd =
                    BiddingHiSavanaNativeProvider.getNativeManager(adManager.getSceneId())
                        ?.getNativeAd()
                tNativeAd?.bindNativeView(hiNativeView!!, nativeInfo, hiViewBinder)
            }
        }
    }
}