package com.transsnet.launcherlib;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author bin.cai
 */
public class PalmStoreDownLoadTaskInfo implements Parcelable {
    private String taskId;
    private String pkgName;
    private String iconUrl;
    private String name;
    private float progress;
    private int status;
    private String fromPage;

    public String getFromPage() {
        return fromPage;
    }

    public void setFromPage(String fromPage) {
        this.fromPage = fromPage;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getPkgName() {
        return pkgName;
    }

    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getProgress() {
        return progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }


    public PalmStoreDownLoadTaskInfo() {

    }

    protected PalmStoreDownLoadTaskInfo(Parcel in) {
        taskId = in.readString();
        pkgName = in.readString();
        iconUrl = in.readString();
        name = in.readString();
        progress = in.readFloat();
        status = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(taskId);
        dest.writeString(pkgName);
        dest.writeString(iconUrl);
        dest.writeString(name);
        dest.writeFloat(progress);
        dest.writeInt(status);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PalmStoreDownLoadTaskInfo> CREATOR = new Creator<PalmStoreDownLoadTaskInfo>() {
        @Override
        public PalmStoreDownLoadTaskInfo createFromParcel(Parcel in) {
            return new PalmStoreDownLoadTaskInfo(in);
        }

        @Override
        public PalmStoreDownLoadTaskInfo[] newArray(int size) {
            return new PalmStoreDownLoadTaskInfo[size];
        }
    };
}
