/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.util;

import com.transsion.ad.AdLogger;
import java.io.File;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J*\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u001a\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0014j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0006\u00a8\u0006\u001a"}, d2={"Lcom/transsion/ad/util/FileUtil;", "", "()V", "checkFilesExistence", "", "directoryPath", "", "clearFolder", "", "folderPath", "retainDir", "convertBytesToMegabytes", "", "bytes", "", "createDirectoryIfNotExists", "deleteFile", "file", "Ljava/io/File;", "set", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getFileLastModifiedTime", "filePath", "getFolderSize", "isFileExists", "lib_ad_release"})
@SourceDebugExtension(value={"SMAP\nFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtil.kt\ncom/transsion/ad/util/FileUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n13309#2,2:155\n*S KotlinDebug\n*F\n+ 1 FileUtil.kt\ncom/transsion/ad/util/FileUtil\n*L\n45#1:155,2\n*E\n"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    public final void createDirectoryIfNotExists(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        AdLogger.logAdInit$default(AdLogger.INSTANCE, this.getClass().getSimpleName() + " --> createDirectoryIfNotExists() --> \u76ee\u6807\u6587\u4ef6\u5939 \u521b\u5efa\u6210\u529f --> directoryPath = " + directoryPath, false, 2, null);
    }

    public final boolean isFileExists(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        return file.exists();
    }

    public final void deleteFile(@NotNull File file, @NotNull HashSet<String> set) {
        block4: {
            File[] listFiles;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(set, (String)"set");
            if (!file.isDirectory()) break block4;
            if (listFiles != null) {
                File[] it = listFiles = file.listFiles();
                boolean bl = false;
                if (!(listFiles.length == 0)) {
                    File[] $this$forEach$iv = listFiles;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it2 = element$iv = $this$forEach$iv[i];
                        boolean bl2 = false;
                        if (it2.isDirectory()) {
                            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                            INSTANCE.deleteFile(it2, set);
                            continue;
                        }
                        if (!it2.isFile() || set.contains(it2.getPath())) continue;
                        it2.delete();
                    }
                }
            }
        }
    }

    public final double convertBytesToMegabytes(long bytes) {
        return (double)bytes / (double)0x100000;
    }

    public final void clearFolder(@NotNull String folderPath, @Nullable String retainDir) {
        File[] files;
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        File folder = new File(folderPath);
        if (folder.exists() && folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                if (!file.isDirectory()) continue;
                if (retainDir != null) {
                    String string2 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
                    if (StringsKt.endsWith((String)string2, (String)retainDir, (boolean)true)) continue;
                }
                String string3 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
                this.clearFolder(string3, retainDir);
            }
        }
    }

    public static /* synthetic */ void clearFolder$default(FileUtil fileUtil, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        fileUtil.clearFolder(string2, string3);
    }

    public final long getFileLastModifiedTime(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        return file.lastModified();
    }

    public final boolean checkFilesExistence(@NotNull String directoryPath) {
        File[] files;
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        File directory = new File(directoryPath);
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                return file.exists();
            }
        }
        return false;
    }

    public final long getFolderSize(@NotNull String folderPath) {
        File[] files;
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        File folder = new File(folderPath);
        long size = 0L;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (file.isFile()) {
                    size += file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                String string2 = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
                size += this.getFolderSize(string2);
            }
        }
        return size;
    }
}

