/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.view.blur;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.ImageUtils;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.transsion.ad.view.blur.FastBlur;
import java.security.MessageDigest;

public class BlurTransformation
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "BlurTransformation.1";
    private static final int MAX_RADIUS = 25;
    private static final int DEFAULT_DOWN_SAMPLING = 1;
    private final int radius;
    private final int sampling;
    private boolean isUseCustomBlur = false;

    public BlurTransformation() {
        this(25, 1);
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        int width = toTransform.getWidth();
        int height = toTransform.getHeight();
        int scaledWidth = width / this.sampling;
        int scaledHeight = height / this.sampling;
        Bitmap bitmap = pool.get(scaledWidth, scaledHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.sampling, 1.0f / (float)this.sampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(toTransform, 0.0f, 0.0f, paint);
        bitmap = this.isUseCustomBlur ? FastBlur.blur(bitmap, this.radius, true) : ImageUtils.fastBlur((Bitmap)bitmap, (float)1.0f, (float)this.radius);
        return bitmap;
    }

    public BlurTransformation(int radius) {
        this(radius, 1);
    }

    public BlurTransformation(int radius, int sampling) {
        this.radius = radius;
        this.sampling = sampling;
    }

    public BlurTransformation(int radius, int sampling, boolean isUseCustomBlur) {
        this.radius = radius;
        this.sampling = sampling;
        this.isUseCustomBlur = isUseCustomBlur;
    }

    public String toString() {
        return "BlurTransformation(radius=" + this.radius + ", sampling=" + this.sampling + ")";
    }

    public boolean equals(Object o) {
        return o instanceof BlurTransformation && ((BlurTransformation)((Object)o)).radius == this.radius && ((BlurTransformation)((Object)o)).sampling == this.sampling;
    }

    public int hashCode() {
        return ID.hashCode() + this.radius * 1000 + this.sampling * 10;
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.radius + this.sampling).getBytes(CHARSET));
    }
}

