package com.transsion.ad.bidding.banner

import com.hisavana.common.bean.AdditionalInfo
import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/5/28 15:00
 * @description: Banner 竞价广告 触发展示
 */
class BiddingBannerManager : AbsAdBidding() {

    private var hiSavanaBannerProvider: BiddingHiSavanaBannerProvider? = null // HI广告加载对象
    private var biddingBuyOutBannerView: BiddingBuyOutBannerView? = null // 包断广告对象
    private var hiAdPlans: AdPlans? = null


    // ===================================== Hi程序化广告回调 ========================================


    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_BANNER

    override fun getLogTag(): String = AdLogger.TAG_AD_BANNER

    override fun checkContextNonNull(): Boolean = true

    override fun getGemini(): AbsBiddingBuyOutGemini? = null

    override fun onLoadSuccess(p0: AdditionalInfo) {
        super.onLoadSuccess(p0)
        // Hi程序化请求成功之后加入竞价队列
        if (isUseHiEcpm(hiAdPlans)) {
            hiAdPlans?.bidEcpmCent = p0.ecpm
        }

        // 加载到竞价队列
        getBiddingPlanList()?.add(
            BiddingIntermediateMaterialBean(
                ecpm = hiAdPlans?.bidEcpmCent,
                plans = hiAdPlans,
                hiSavanaBannerProvider = hiSavanaBannerProvider,
                isExpend = false
            )
        )
    }

    override fun destroy() {
        super.destroy()
        biddingBuyOutBannerView?.destroy()
        hiSavanaBannerProvider?.destroy()
        getBiddingPlanList()?.clear()
    }

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>, adPlans: AdPlans
    ) {
        if (null == hiSavanaBannerProvider) {
            hiSavanaBannerProvider = BiddingHiSavanaBannerProvider()
            hiSavanaBannerProvider?.setSceneId(getSceneId())
            hiSavanaBannerProvider?.setCtxMap(getCtxMap())
            hiSavanaBannerProvider?.setContext(getContext())
            hiSavanaBannerProvider?.setListener(this)
        }
        hiAdPlans = adPlans
        hiSavanaBannerProvider?.loadAd()
    }

    override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
        if (maxEcpmObject?.hiSavanaBannerProvider == null) {
            getContext()?.let {
                biddingBuyOutBannerView = BiddingBuyOutBannerView(it)
                biddingBuyOutBannerView?.setAdPlans(maxEcpmObject?.plans)
                biddingBuyOutBannerView?.setSceneId(getSceneId())
                biddingBuyOutBannerView?.setListener(this)
            }
            maxEcpmObject?.bannerView = biddingBuyOutBannerView
        } else {
            maxEcpmObject.bannerView = hiSavanaBannerProvider?.getBannerView()
        }
        super.onBiddingLoad(maxEcpmObject)
    }


    // =============================================================================================


    /**
     * 展示的时候调用
     */
    fun showBannerAd() {
        biddingBuyOutBannerView?.showAd()
    }

}