package com.transsion.ad.bidding.icon

import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.AdditionalInfo
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.common.interfacz.TAdditionalListener
import com.hisavana.mediation.ad.TNativeAd
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.hi.HiSavanaAdManager
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.scene.SceneCommonConfig

/**
 * @author shmizhangxinbing
 * @date : 2025/8/20 20:13
 * @description: 程序化加载Icon广告
 */
class BiddingHiSavanaIconAdManager : TAdditionalListener() {

    /**
     * 当前正在请求中
     */
    private var isLoading = false

    /**
     * 广告加载对象 负责广告的加载
     */
    private var tNativeAd: TNativeAd? = null

    private var mListener: BiddingTAdditionalListener? = null

    /**
     * 场景调用的时候传进来的场景ID
     */
    private var mSceneId: String? = null

    private fun getClassTag(): String = javaClass.simpleName


    // ============================ 广告SDK回调 =====================================================


    override fun onLoadSuccess(p0: AdditionalInfo) {
        super.onLoadSuccess(p0)

        // getNativeAdInfo()	获取Native广告，返回一个List(2.6.8.+新增)
        // getNativeInfoSize()	获取当前可用的广告的数量(2.6.8.+新增)
        val nativeAdInfo = tNativeAd?.nativeAdInfo
        nativeAdInfo?.let {
            mListener?.onHiIconAdReady(it)
        }
    }

    override fun onLoadFailure(p0: TAdErrorCode?, p1: AdditionalInfo) {
        super.onLoadFailure(p0, p1)
        mListener?.onLoadFailure(p0, p1)
    }

    override fun onShow(p0: TAdNativeInfo?, p1: AdditionalInfo) {
        super.onShow(p0, p1)
        mListener?.onShow(p0, p1)
    }

    override fun onShowError(p0: TAdErrorCode?, p1: AdditionalInfo) {
        super.onShowError(p0, p1)
        mListener?.onShowError(p0, p1)
    }

    override fun onClick(p0: TAdNativeInfo?, p1: AdditionalInfo) {
        super.onClick(p0, p1)
        mListener?.onClick(p0, p1)
    }


    // ======================================== API ================================================


    /**
     * 资源回收
     */
    fun destroy() {
        mListener = null
        tNativeAd?.destroy()
        tNativeAd = null
    }

    /**
     * 设置回调
     */
    fun setListener(listener: BiddingTAdditionalListener) {
        mListener = listener
    }

    /**
     * 场景信息传递进来
     */
    fun setSceneId(sceneId: String) {
        mSceneId = sceneId
    }

    fun getSceneId(): String? = mSceneId

    /**
     * 获取广告加载对象
     */
    fun getNativeAd(): TNativeAd? = tNativeAd

    /**
     * 加载广告
     */
    fun loadAd() {
        // 如果没有初始化，那就不进行任何操作
        if (HiSavanaAdManager.isInitialized().not()) {
            mListener?.onLoadFailure(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, "广告SDK没有初始化"
                ), AdditionalInfo()
            )
            return
        }

        val placementId = SceneCommonConfig.getHiSavanaPlacementId(getSceneId()) ?: ""

        // 如果配置为空那就直接返回
        if (TextUtils.isEmpty(placementId)) {
            mListener?.onLoadFailure(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, "当前场景配置不存在"
                ), AdditionalInfo()
            )
            return
        }

        // 如果正在请求中那就return 这个isLoading 仅在SDK回调的onLoad和onError修改
        if (isLoading) {
            return
        }
        isLoading = true

        // 加载广告
        if (null == tNativeAd) {
            tNativeAd = TNativeAd(Utils.getApp(), placementId)
            tNativeAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdditionalListener(this).build()
            )
            AdLogger.logSdk(
                tag = AdLogger.TAG_AD_ICON,
                msg = "${getClassTag()} --> loadAd() --> ==================== mPlacementId = $placementId --> create TNativeAd() =================== "
            )
        }

        tNativeAd?.loadAd()
    }
}